/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.group;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupSubtotalsReport {
    public GroupSubtotalsReport() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupSubtotalsReport();
    }

    private void build() {
        TextColumnBuilder yearColumn = DynamicReports.col.column("Order year", "orderdate", (DRIDataType)DynamicReports.type.dateYearType());
        TextColumnBuilder monthColumn = DynamicReports.col.column("Order month", "orderdate", (DRIDataType)DynamicReports.type.dateMonthType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        ColumnGroupBuilder yearGroup = (ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)yearColumn).groupByDataType();
        ColumnGroupBuilder monthGroup = ((ColumnGroupBuilder)((ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)monthColumn).groupByDataType()).setHeaderLayout(GroupHeaderLayout.EMPTY)).setHideColumn(Boolean.valueOf(false));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setSubtotalStyle((ReportStyleBuilder)Templates.columnStyle)).setShowColumnValues(Boolean.valueOf(false))).columns(new ColumnBuilder[]{yearColumn, monthColumn, quantityColumn, unitPriceColumn})).groupBy(new GroupBuilder[]{yearGroup, monthGroup})).subtotalsAtGroupFooter((GroupBuilder)monthGroup, new SubtotalBuilder[]{DynamicReports.sbt.first((ValueColumnBuilder)monthColumn), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupSubtotals")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "quantity", "unitprice"});
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        for (int i = 0; i < 200; ++i) {
            Date date = c.getTime();
            dataSource.add(new Object[]{date, (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
            c.add(5, 1);
        }
        return dataSource;
    }
}

