/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.group;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupHeaderWithSubtotalReport {
    public GroupHeaderWithSubtotalReport() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupHeaderWithSubtotalReport();
    }

    private void build() {
        TextColumnBuilder yearColumn = DynamicReports.col.column("Order year", (DRIExpression)DynamicReports.exp.text(""));
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        CustomGroupBuilder yearGroup = (CustomGroupBuilder)((CustomGroupBuilder)DynamicReports.grp.group((DRIExpression)new YearExpression()).groupByDataType()).headerWithSubtotal();
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setSubtotalStyle((ReportStyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.boldStyle))).fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", (DRIDataType)DynamicReports.type.dateYearType())})).columns(new ColumnBuilder[]{yearColumn, orderDateColumn, itemColumn, quantityColumn, unitPriceColumn})).groupBy(new GroupBuilder[]{yearGroup})).subtotalsAtGroupHeader((GroupBuilder)yearGroup, new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.aggregate((DRIExpression)DynamicReports.exp.text("Total"), (ColumnBuilder)yearColumn, Calculation.NOTHING), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn), DynamicReports.sbt.sum((ValueColumnBuilder)unitPriceColumn)})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupHeaderWithSubtotal")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "Tablet", 5, new BigDecimal(250)});
        dataSource.add(new Object[]{this.toDate(2009, 11, 1), "Laptop", 3, new BigDecimal(480)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "Smartphone", 1, new BigDecimal(280)});
        dataSource.add(new Object[]{this.toDate(2009, 12, 1), "Tablet", 1, new BigDecimal(190)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "Tablet", 4, new BigDecimal(230)});
        dataSource.add(new Object[]{this.toDate(2010, 1, 1), "Laptop", 2, new BigDecimal(650)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "Laptop", 3, new BigDecimal(550)});
        dataSource.add(new Object[]{this.toDate(2010, 2, 1), "Smartphone", 5, new BigDecimal(210)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    private class YearExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            return DynamicReports.type.dateYearType().valueToString("orderdate", reportParameters);
        }
    }
}

