/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.group;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class FieldGroupReport {
    public FieldGroupReport() {
        this.build();
    }

    public static void main(String[] args) {
        new FieldGroupReport();
    }

    private void build() {
        StyleBuilder groupStyle = (StyleBuilder)DynamicReports.stl.style().bold();
        CustomGroupBuilder itemGroup = (CustomGroupBuilder)((CustomGroupBuilder)((CustomGroupBuilder)((CustomGroupBuilder)DynamicReports.grp.group("item", String.class).setStyle((ReportStyleBuilder)groupStyle)).setTitle("Item").setTitleStyle((ReportStyleBuilder)groupStyle)).setTitleWidth(Integer.valueOf(30))).setHeaderLayout(GroupHeaderLayout.TITLE_AND_VALUE);
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new GroupBuilder[]{itemGroup})).title(new ComponentBuilder[]{Templates.createTitleComponent("FieldGroup")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Tablet", this.toDate(2010, 1, 1), 5, new BigDecimal(300)});
        dataSource.add(new Object[]{"Tablet", this.toDate(2010, 1, 3), 1, new BigDecimal(280)});
        dataSource.add(new Object[]{"Tablet", this.toDate(2010, 1, 19), 5, new BigDecimal(320)});
        dataSource.add(new Object[]{"Laptop", this.toDate(2010, 1, 5), 3, new BigDecimal(580)});
        dataSource.add(new Object[]{"Laptop", this.toDate(2010, 1, 8), 1, new BigDecimal(620)});
        dataSource.add(new Object[]{"Laptop", this.toDate(2010, 1, 15), 5, new BigDecimal(600)});
        dataSource.add(new Object[]{"Smartphone", this.toDate(2010, 1, 18), 8, new BigDecimal(150)});
        dataSource.add(new Object[]{"Smartphone", this.toDate(2010, 1, 20), 8, new BigDecimal(210)});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }
}

