/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.group;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class CustomGroupReport {
    public CustomGroupReport() {
        this.build();
    }

    public static void main(String[] args) {
        new CustomGroupReport();
    }

    private void build() {
        CustomGroupBuilder yearGroup = DynamicReports.grp.group((DRIExpression)new YearExpression());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new GroupBuilder[]{yearGroup})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomGroup")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"2009-11-01", "Tablet", 5, new BigDecimal(250)});
        dataSource.add(new Object[]{"2009-11-01", "Laptop", 3, new BigDecimal(480)});
        dataSource.add(new Object[]{"2009-12-01", "Smartphone", 1, new BigDecimal(280)});
        dataSource.add(new Object[]{"2009-12-01", "Tablet", 1, new BigDecimal(190)});
        dataSource.add(new Object[]{"2010-01-01", "Tablet", 4, new BigDecimal(230)});
        dataSource.add(new Object[]{"2010-01-01", "Laptop", 2, new BigDecimal(650)});
        dataSource.add(new Object[]{"2010-02-01", "Laptop", 3, new BigDecimal(550)});
        dataSource.add(new Object[]{"2010-02-01", "Smartphone", 5, new BigDecimal(210)});
        return dataSource;
    }

    private class YearExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            String orderDate = (String)reportParameters.getValue("orderdate");
            return orderDate.split("-")[0];
        }
    }
}

