/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.gettingstarted;

import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.exception.DRException;

public class ContainerReport {
    private StyleBuilder boldCenteredStyle;
    private StyleBuilder borderedStyle;

    public ContainerReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ContainerReport();
    }

    private void build() {
        this.boldCenteredStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style().bold()).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        this.borderedStyle = DynamicReports.stl.style(DynamicReports.stl.pen1Point());
        try {
            ((JasperReportBuilder)DynamicReports.report().title(new ComponentBuilder[]{this.createTextField("Horizontal list (contains 10 textfields)"), this.createHorizontalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Multi row horizontal list (contains 10 textfields)"), this.createMultiRowHorizontalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Horizontal flow list (contains 9 textfields)"), this.createHorizontalFlowList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Vertical list (contains 4 textfields)"), this.createVerticalList(), DynamicReports.cmp.verticalGap(20), this.createTextField("Nested list (contains 1 horizontal and 3 vertical lists)"), this.createNestedList()})).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private TextFieldBuilder<String> createTextField(String label) {
        return (TextFieldBuilder)DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)this.boldCenteredStyle);
    }

    private ComponentBuilder<?, ?> createHorizontalList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        for (int i = 0; i < 10; ++i) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createMultiRowHorizontalList() {
        int i;
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        for (i = 0; i < 3; ++i) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
        }
        horizontalList.newRow();
        for (i = 0; i < 7; ++i) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createHorizontalFlowList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalFlowList();
        for (int i = 0; i < 9; ++i) {
            horizontalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
        }
        return horizontalList;
    }

    private ComponentBuilder<?, ?> createVerticalList() {
        VerticalListBuilder verticalList = DynamicReports.cmp.verticalList();
        for (int i = 0; i < 4; ++i) {
            verticalList.add(new ComponentBuilder[]{DynamicReports.cmp.text("").setStyle((ReportStyleBuilder)this.borderedStyle)});
        }
        return verticalList;
    }

    private ComponentBuilder<?, ?> createNestedList() {
        HorizontalListBuilder horizontalList = DynamicReports.cmp.horizontalList();
        for (int i = 0; i < 3; ++i) {
            horizontalList.add(new ComponentBuilder[]{this.createVerticalList()});
        }
        return horizontalList;
    }
}

