/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.genericelement.openflashchart;

import cn.myapps.report.examples.genericelement.openflashchart.ChartGenerator;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;
import org.apache.commons.collections.map.ReferenceMap;

public class OpenFlashChartPdfHandler
implements GenericElementPdfHandler {
    private final ReferenceMap existingContexts = new ReferenceMap(2, 0);

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public void exportElement(JRPdfExporterContext exporterContext, JRGenericPrintElement element) {
        try {
            PdfIndirectObject swfRef;
            boolean newContext;
            PdfWriter writer = exporterContext.getPdfWriter();
            boolean bl = newContext = !this.existingContexts.containsKey((Object)exporterContext);
            if (newContext) {
                PdfDictionary extensions = new PdfDictionary();
                PdfDictionary adobeExtension = new PdfDictionary();
                adobeExtension.put(new PdfName("BaseVersion"), (PdfObject)PdfWriter.PDF_VERSION_1_7);
                adobeExtension.put(new PdfName("ExtensionLevel"), (PdfObject)new PdfNumber(3));
                extensions.put(new PdfName("ADBE"), (PdfObject)adobeExtension);
                writer.getExtraCatalog().put(new PdfName("Extensions"), (PdfObject)extensions);
                byte[] swfData = this.getChartSwf();
                PdfFileSpecification swfFile = PdfFileSpecification.fileEmbedded((PdfWriter)writer, null, (String)"Open Flash Chart", (byte[])swfData);
                swfRef = writer.addToBody((PdfObject)swfFile);
                this.existingContexts.put((Object)exporterContext, (Object)swfRef);
            } else {
                swfRef = (PdfIndirectObject)this.existingContexts.get((Object)exporterContext);
            }
            Rectangle rect = new Rectangle((float)(element.getX() + exporterContext.getOffsetX()), (float)(exporterContext.getExportedReport().getPageHeight() - element.getY() - exporterContext.getOffsetY()), (float)(element.getX() + exporterContext.getOffsetX() + element.getWidth()), (float)(exporterContext.getExportedReport().getPageHeight() - element.getY() - exporterContext.getOffsetY() - element.getHeight()));
            PdfAnnotation ann = new PdfAnnotation(writer, rect);
            ann.put(PdfName.SUBTYPE, (PdfObject)new PdfName("RichMedia"));
            PdfDictionary settings = new PdfDictionary();
            PdfDictionary activation = new PdfDictionary();
            activation.put(new PdfName("Condition"), (PdfObject)new PdfName("PV"));
            settings.put(new PdfName("Activation"), (PdfObject)activation);
            ann.put(new PdfName("RichMediaSettings"), (PdfObject)settings);
            PdfDictionary content = new PdfDictionary();
            HashMap<String, PdfIndirectReference> assets = new HashMap<String, PdfIndirectReference>();
            assets.put("map.swf", swfRef.getIndirectReference());
            PdfDictionary assetsDictionary = PdfNameTree.writeTree(assets, (PdfWriter)writer);
            content.put(new PdfName("Assets"), (PdfObject)assetsDictionary);
            PdfArray configurations = new PdfArray();
            PdfDictionary configuration = new PdfDictionary();
            PdfArray instances = new PdfArray();
            PdfDictionary instance = new PdfDictionary();
            instance.put(new PdfName("Subtype"), (PdfObject)new PdfName("Flash"));
            PdfDictionary params = new PdfDictionary();
            String chartData = ((ChartGenerator)element.getParameterValue("CHARTGENERATOR")).generateChart();
            String vars = "inline_data=" + chartData;
            params.put(new PdfName("FlashVars"), (PdfObject)new PdfString(vars));
            instance.put(new PdfName("Params"), (PdfObject)params);
            instance.put(new PdfName("Asset"), (PdfObject)swfRef.getIndirectReference());
            PdfIndirectObject instanceRef = writer.addToBody((PdfObject)instance);
            instances.add((PdfObject)instanceRef.getIndirectReference());
            configuration.put(new PdfName("Instances"), (PdfObject)instances);
            PdfIndirectObject configurationRef = writer.addToBody((PdfObject)configuration);
            configurations.add((PdfObject)configurationRef.getIndirectReference());
            content.put(new PdfName("Configurations"), (PdfObject)configurations);
            ann.put(new PdfName("RichMediaContent"), (PdfObject)content);
            writer.addAnnotation(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getChartSwf() throws IOException {
        int nRead;
        InputStream is = OpenFlashChartPdfHandler.class.getResourceAsStream("open-flash-chart.swf");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

