/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.expression;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class SimpleExpressionReport {
    public SimpleExpressionReport() {
        this.build();
    }

    public static void main(String[] args) {
        new SimpleExpressionReport();
    }

    private void build() {
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{DynamicReports.field((String)"quantity", Integer.class), DynamicReports.field((String)"unitprice", BigDecimal.class)})).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Price", (DRIExpression)new SimpleExpression())})).title(new ComponentBuilder[]{Templates.createTitleComponent("SimpleExpression")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 20, new BigDecimal(10)});
        return dataSource;
    }

    private class SimpleExpression
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private SimpleExpression() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            Integer quantity = (Integer)reportParameters.getValue("quantity");
            BigDecimal unitPrice = (BigDecimal)reportParameters.getValue("unitprice");
            return new BigDecimal(quantity).multiply(unitPrice);
        }
    }
}

