/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.expression;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ComplexExpressionReport {
    public ComplexExpressionReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ComplexExpressionReport();
    }

    private void build() {
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Price", (DRIExpression)new ComplexExpression())})).title(new ComponentBuilder[]{Templates.createTitleComponent("ComplexExpression")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 20, new BigDecimal(10)});
        return dataSource;
    }

    private class ComplexExpression
    extends AbstractComplexExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        public ComplexExpression() {
            this.addExpression(DynamicReports.field((String)"quantity", Integer.class));
            this.addExpression(DynamicReports.field((String)"unitprice", BigDecimal.class));
        }

        public BigDecimal evaluate(List<?> values, ReportParameters reportParameters) {
            Integer quantity = (Integer)values.get(0);
            BigDecimal unitPrice = (BigDecimal)values.get(1);
            return new BigDecimal(quantity).multiply(unitPrice);
        }
    }
}

