/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.datasource;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.SubreportBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class CollectionDatasourceReport {
    public CollectionDatasourceReport() {
        this.build();
    }

    public static void main(String[] args) {
        new CollectionDatasourceReport();
    }

    private void build() {
        SubreportBuilder subreport = DynamicReports.cmp.subreport(this.createSubreport()).setDataSource((DRIExpression)DynamicReports.exp.subDatasourceBeanCollection("subData"));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitPrice", (DRIDataType)DynamicReports.type.bigDecimalType())})).title(new ComponentBuilder[]{Templates.createTitleComponent("CollectionDatasource")})).detailFooter(new ComponentBuilder[]{DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.horizontalGap(150), subreport, DynamicReports.cmp.horizontalGap(150)}), DynamicReports.cmp.line()})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JasperReportBuilder createSubreport() {
        JasperReportBuilder report = DynamicReports.report();
        ((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{DynamicReports.cmp.text("SubData").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)})).columns(new ColumnBuilder[]{DynamicReports.col.column("Order date", "orderDate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType())});
        return report;
    }

    private JRDataSource createDataSource() {
        ArrayList<Data> data = new ArrayList<Data>();
        ArrayList<SubData> subData = new ArrayList<SubData>();
        subData.add(new SubData(this.toDate(2011, 0, 10), 2));
        subData.add(new SubData(this.toDate(2011, 0, 15), 3));
        data.add(new Data("DVD", 5, new BigDecimal(30), subData));
        subData = new ArrayList();
        subData.add(new SubData(this.toDate(2011, 0, 11), 1));
        subData.add(new SubData(this.toDate(2011, 0, 12), 3));
        subData.add(new SubData(this.toDate(2011, 0, 16), 4));
        data.add(new Data("Book", 8, new BigDecimal(11), subData));
        subData = new ArrayList();
        subData.add(new SubData(this.toDate(2011, 0, 9), 1));
        subData.add(new SubData(this.toDate(2011, 0, 18), 1));
        data.add(new Data("PDA", 2, new BigDecimal(15), subData));
        return new JRBeanCollectionDataSource(data);
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public class SubData {
        private Date orderDate;
        private Integer quantity;

        public SubData(Date orderDate, Integer quantity) {
            this.orderDate = orderDate;
            this.quantity = quantity;
        }

        public Date getOrderDate() {
            return this.orderDate;
        }

        public void setOrderDate(Date orderDate) {
            this.orderDate = orderDate;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }
    }

    public class Data {
        private String item;
        private Integer quantity;
        private BigDecimal unitPrice;
        private List<SubData> subData;

        public Data(String item, Integer quantity, BigDecimal unitPrice, List<SubData> subData) {
            this.item = item;
            this.quantity = quantity;
            this.unitPrice = unitPrice;
            this.subData = subData;
        }

        public String getItem() {
            return this.item;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public BigDecimal getUnitPrice() {
            return this.unitPrice;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }

        public List<SubData> getSubData() {
            return this.subData;
        }

        public void setSubData(List<SubData> subData) {
            this.subData = subData;
        }
    }
}

