/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.crosstab;

import cn.myapps.report.examples.Templates;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupExpressionCrosstabReport {
    public GroupExpressionCrosstabReport() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupExpressionCrosstabReport();
    }

    private void build() {
        CrosstabRowGroupBuilder rowGroup = DynamicReports.ctab.rowGroup("state", String.class);
        CrosstabColumnGroupBuilder columnYearGroup = DynamicReports.ctab.columnGroup((DRIExpression)new YearExpression());
        CrosstabColumnGroupBuilder columnQuarterGroup = DynamicReports.ctab.columnGroup((DRIExpression)new QuarterExpression());
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().setCellWidth(Integer.valueOf(50)).headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Date").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnYearGroup, columnQuarterGroup}).measures(new CrosstabMeasureBuilder[]{DynamicReports.ctab.measure("quantity", Integer.class, Calculation.SUM)});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", Date.class)})).setPageFormat(PageType.A4, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupExpressionCrosstab")})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"state", "orderdate", "quantity"});
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < 700; ++i) {
            Date date = c.getTime();
            dataSource.add(new Object[]{"New York", date, (int)(Math.random() * 10.0) + 1});
            dataSource.add(new Object[]{"Washington", date, (int)(Math.random() * 10.0) + 1});
            dataSource.add(new Object[]{"Florida", date, (int)(Math.random() * 10.0) + 1});
            c.add(5, -1);
        }
        return dataSource;
    }

    private class QuarterExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private QuarterExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)reportParameters.getValue("orderdate"));
            return "Q" + (c.get(2) / 3 + 1);
        }
    }

    private class YearExpression
    extends AbstractSimpleExpression<Integer> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public Integer evaluate(ReportParameters reportParameters) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)reportParameters.getValue("orderdate"));
            return c.get(1);
        }
    }
}

