/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.shippinglabel;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.complex.shippinglabel.Customer;
import cn.myapps.report.examples.complex.shippinglabel.ShippingLabel;
import cn.myapps.report.examples.complex.shippinglabel.ShippingLabelData;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.barcode.Code128BarcodeBuilder;
import net.sf.dynamicreports.report.builder.barcode.Ean128BarcodeBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class ShippingLabelDesign {
    private ShippingLabelData data = new ShippingLabelData();
    private StyleBuilder bold14Style;

    public static void main(String[] args) {
        ShippingLabelDesign design = new ShippingLabelDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        ShippingLabel shippingLabel = this.data.getShippingLabel();
        StyleBuilder textStyle = (StyleBuilder)DynamicReports.stl.style().setFontSize(Integer.valueOf(12));
        this.bold14Style = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.boldStyle).setFontSize(Integer.valueOf(14));
        StyleBuilder boldCentered30Style = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)this.bold14Style).setFontSize(Integer.valueOf(30))).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        StyleBuilder boldCentered100Style = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCentered30Style).setFontSize(Integer.valueOf(100));
        Ean128BarcodeBuilder shippingContainerCode = (Ean128BarcodeBuilder)((Ean128BarcodeBuilder)DynamicReports.bcode.ean128("100264835710351").setModuleWidth(Double.valueOf(2.5))).setStyle((ReportStyleBuilder)this.bold14Style);
        Code128BarcodeBuilder shipToPostalCode = (Code128BarcodeBuilder)((Code128BarcodeBuilder)DynamicReports.bcode.code128("09820").setModuleWidth(Double.valueOf(3.0))).setStyle((ReportStyleBuilder)this.bold14Style);
        TextFieldBuilder priority = (TextFieldBuilder)DynamicReports.cmp.text((Number)shippingLabel.getPriority()).setStyle((ReportStyleBuilder)boldCentered100Style);
        TextFieldBuilder pod = (TextFieldBuilder)DynamicReports.cmp.text(shippingLabel.getPod()).setStyle((ReportStyleBuilder)boldCentered30Style);
        TextFieldBuilder dateShipped = DynamicReports.cmp.text((DRIExpression)DynamicReports.exp.date(shippingLabel.getDateShipped())).setDataType((DRIDataType)DynamicReports.type.dateType());
        TextFieldBuilder po = (TextFieldBuilder)DynamicReports.cmp.text(shippingLabel.getPo()).setStyle((ReportStyleBuilder)boldCentered30Style);
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).setPageFormat(PageType.A5)).setTextStyle((ReportStyleBuilder)textStyle)).title(new ComponentBuilder[]{Templates.createTitleComponent("ShippingLabel"), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{this.createCustomerComponent("From", shippingLabel.getFrom()), this.createCustomerComponent("To", shippingLabel.getTo())}), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.verticalList(new ComponentBuilder[]{this.createCellComponent("Priority", (ComponentBuilder<?, ?>)priority), this.createCellComponent("POD", (ComponentBuilder<?, ?>)pod)}), DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.horizontalList(new ComponentBuilder[]{this.createCellComponent("Carrier", (ComponentBuilder<?, ?>)DynamicReports.cmp.text(shippingLabel.getCarrier())), this.createCellComponent("Date shipped", (ComponentBuilder<?, ?>)dateShipped)}), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{this.createCellComponent("Weight", (ComponentBuilder<?, ?>)DynamicReports.cmp.text((Number)shippingLabel.getWeight())), this.createCellComponent("Quantity", (ComponentBuilder<?, ?>)DynamicReports.cmp.text((Number)shippingLabel.getQuantity()))}), this.createCellComponent("Ship to postal code", (ComponentBuilder<?, ?>)shipToPostalCode)})}), this.createCellComponent("PO", (ComponentBuilder<?, ?>)po), this.createCellComponent("Serial shipping container", (ComponentBuilder<?, ?>)shippingContainerCode)});
        return report;
    }

    private ComponentBuilder<?, ?> createCustomerComponent(String label, Customer customer) {
        VerticalListBuilder content = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(customer.getName()), DynamicReports.cmp.text(customer.getAddress()), DynamicReports.cmp.text(customer.getCity())});
        return this.createCellComponent(label, (ComponentBuilder<?, ?>)content);
    }

    private ComponentBuilder<?, ?> createCellComponent(String label, ComponentBuilder<?, ?> content) {
        VerticalListBuilder cell = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)this.bold14Style), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.horizontalGap(20), content, DynamicReports.cmp.horizontalGap(5)})});
        cell.setStyle((ReportStyleBuilder)DynamicReports.stl.style(DynamicReports.stl.pen2Point()));
        return cell;
    }
}

