/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.salestableofcontents;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.complex.salestableofcontents.SalesTableOfContentsData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.group.CustomGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsCustomizer;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.HyperLinkType;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.definition.DRICustomValues;
import net.sf.dynamicreports.report.definition.DRITableOfContentsCustomizer;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class SalesTableOfContentsDesign {
    private SalesTableOfContentsData data = new SalesTableOfContentsData();

    public static void main(String[] args) {
        SalesTableOfContentsDesign design = new SalesTableOfContentsDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        StyleBuilder headingToc1Style = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.rootStyle).italic();
        CustomTableOfContentsCustomizer tableOfContentsCustomizer = new CustomTableOfContentsCustomizer();
        tableOfContentsCustomizer.setHeadingStyle(1, (ReportStyleBuilder)headingToc1Style);
        tableOfContentsCustomizer.setTextFixedWidth(100);
        tableOfContentsCustomizer.setPageIndexFixedWidth(30);
        TextFieldBuilder pageHeader = ((TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new PageHeaderExpression()).setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle)).setEvaluationTime(Evaluation.PAGE);
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setPageFormat(PageType.A5, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).setTableOfContents((DRITableOfContentsCustomizer)tableOfContentsCustomizer)).columns(new ColumnBuilder[]{countryColumn, itemColumn, DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateType()), DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()), DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType())})).groupBy(new ValueColumnBuilder[]{countryColumn, itemColumn})).pageHeader(new ComponentBuilder[]{pageHeader})).title(new ComponentBuilder[]{Templates.createTitleComponent("SalesTableOfContents")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.data.createDataSource());
        return report;
    }

    private class CustomTableOfContentsCustomizer
    extends TableOfContentsCustomizer {
        private static final long serialVersionUID = 1L;

        private CustomTableOfContentsCustomizer() {
        }

        public void customize() {
            super.customize();
            CustomGroupBuilder countryGroup = (CustomGroupBuilder)((CustomGroupBuilder)((CustomGroupBuilder)DynamicReports.grp.group((DRIExpression)new CountryExpression(this.textField)).setHeaderLayout(GroupHeaderLayout.EMPTY)).header(new ComponentBuilder[]{this.countryHeadingComponent()})).footer(new ComponentBuilder[]{DynamicReports.cmp.verticalGap(5)});
            this.report.setPageColumnsPerPage(Integer.valueOf(2)).setPageColumnSpace(Integer.valueOf(10)).groupBy(new GroupBuilder[]{countryGroup});
        }

        private ComponentBuilder<?, ?> countryHeadingComponent() {
            HorizontalListBuilder headingComponent = DynamicReports.cmp.horizontalList();
            HyperLinkBuilder countryReferenceHyperLink = DynamicReports.hyperLink();
            countryReferenceHyperLink.setAnchor((DRIExpression)new CountryExpression(this.referenceField));
            countryReferenceHyperLink.setType(HyperLinkType.LOCAL_ANCHOR);
            StyleBuilder style = (StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.rootStyle).setFontSize(Integer.valueOf(12))).bold()).setBackgroundColor(Color.LIGHT_GRAY);
            TextFieldBuilder textComponent = (TextFieldBuilder)((TextFieldBuilder)DynamicReports.cmp.text(this.textField).setHyperLink(countryReferenceHyperLink)).setStyle((ReportStyleBuilder)style);
            headingComponent.add(new ComponentBuilder[]{textComponent});
            TextFieldBuilder pageIndexComponent = ((TextFieldBuilder)((TextFieldBuilder)DynamicReports.cmp.text((DRIExpression)new CountryHeadingExpression()).setHyperLink(countryReferenceHyperLink)).setStyle((ReportStyleBuilder)style)).setHorizontalTextAlignment(HorizontalTextAlignment.RIGHT);
            headingComponent.add(new ComponentBuilder[]{pageIndexComponent});
            return headingComponent;
        }

        protected ComponentBuilder<?, ?> headingComponent(int level) {
            if (level == 0) {
                return DynamicReports.cmp.filler();
            }
            ComponentBuilder headingComponent = super.headingComponent(level);
            ConditionalStyleBuilder conditionalStyle = (ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.exp.printInOddRow()).setBackgroundColor(new Color(245, 245, 245));
            StyleBuilder rowStyle = DynamicReports.stl.style().conditionalStyles(new ConditionalStyleBuilder[]{conditionalStyle});
            headingComponent.setStyle((ReportStyleBuilder)rowStyle);
            return headingComponent;
        }

        private class CountryHeadingExpression
        extends AbstractComplexExpression<String> {
            private static final long serialVersionUID = 1L;

            private CountryHeadingExpression() {
                VariableBuilder minCountryPage = DynamicReports.variable((FieldBuilder)CustomTableOfContentsCustomizer.this.pageIndexField, (Calculation)Calculation.LOWEST).setResetType(Evaluation.FIRST_GROUP);
                this.addExpression(minCountryPage);
                VariableBuilder maxCountryPage = DynamicReports.variable((FieldBuilder)CustomTableOfContentsCustomizer.this.pageIndexField, (Calculation)Calculation.HIGHEST).setResetType(Evaluation.FIRST_GROUP);
                this.addExpression(maxCountryPage);
            }

            public String evaluate(List<?> values, ReportParameters reportParameters) {
                return values.get(0) + " - " + values.get(1);
            }
        }

        private class CountryExpression
        extends AbstractComplexExpression<String> {
            private static final long serialVersionUID = 1L;
            private String value;

            private CountryExpression(FieldBuilder<String> field) {
                this.addExpression(CustomTableOfContentsCustomizer.this.levelField);
                this.addExpression(field);
            }

            public String evaluate(List<?> values, ReportParameters reportParameters) {
                int level = (Integer)values.get(0);
                if (level == 0) {
                    this.value = (String)values.get(1);
                }
                return this.value;
            }
        }
    }

    private class PageHeaderExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private PageHeaderExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            DRICustomValues customValues = (DRICustomValues)reportParameters.getParameterValue("CUSTOM_VALUES");
            Map tocHeadings = customValues.getTocHeadings();
            if (tocHeadings.isEmpty()) {
                return "";
            }
            ArrayList headings = new ArrayList(tocHeadings.values());
            for (int i = headings.size() - 1; i >= 0; --i) {
                JasperTocHeading jasperTocHeading = (JasperTocHeading)headings.get(i);
                if (jasperTocHeading.getLevel() != 0) continue;
                return "Country: " + jasperTocHeading.getText();
            }
            return "";
        }
    }
}

