/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.salescrosstab;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.complex.salescrosstab.SalesCrosstabData;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabMeasureBuilder;
import net.sf.dynamicreports.report.builder.crosstab.CrosstabRowGroupBuilder;
import net.sf.dynamicreports.report.builder.style.ConditionalStyleBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;

public class SalesCrosstabDesign {
    private SalesCrosstabData data = new SalesCrosstabData();

    public static void main(String[] args) {
        SalesCrosstabDesign design = new SalesCrosstabDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        CrosstabRowGroupBuilder rowStateGroup = DynamicReports.ctab.rowGroup("state", String.class).setHeaderWidth(Integer.valueOf(80));
        CrosstabRowGroupBuilder rowItemGroup = DynamicReports.ctab.rowGroup("item", String.class).setHeaderWidth(Integer.valueOf(80));
        CrosstabColumnGroupBuilder columnYearGroup = DynamicReports.ctab.columnGroup((DRIExpression)new YearExpression());
        CrosstabColumnGroupBuilder columnQuarterGroup = DynamicReports.ctab.columnGroup((DRIExpression)new QuarterExpression());
        CrosstabMeasureBuilder quantityMeasure = DynamicReports.ctab.measure("Quantity", "quantity", Integer.class, Calculation.SUM);
        CrosstabMeasureBuilder unitPriceMeasure = DynamicReports.ctab.measure("Unit price", "unitprice", BigDecimal.class, Calculation.SUM);
        unitPriceMeasure.setPattern("#,###");
        rowStateGroup.orderBy(quantityMeasure);
        ConditionalStyleBuilder condition1 = (ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.cnd.greater((DRIValue)unitPriceMeasure, (Number)50000)).setForegroundColor(Color.GREEN);
        ConditionalStyleBuilder condition2 = (ConditionalStyleBuilder)DynamicReports.stl.conditionalStyle((DRIExpression)DynamicReports.cnd.smaller((DRIValue)unitPriceMeasure, (Number)300)).setForegroundColor(Color.RED);
        StyleBuilder unitPriceStyle = ((StyleBuilder)DynamicReports.stl.style().setBorder(DynamicReports.stl.pen1Point().setLineColor(Color.BLACK))).conditionalStyles(new ConditionalStyleBuilder[]{condition1, condition2});
        unitPriceMeasure.setStyle((ReportStyleBuilder)unitPriceStyle);
        CrosstabBuilder crosstab = DynamicReports.ctab.crosstab().setCellWidth(Integer.valueOf(110)).headerCell(new ComponentBuilder[]{DynamicReports.cmp.text("State / Date").setStyle((ReportStyleBuilder)Templates.boldCenteredStyle)}).rowGroups(new CrosstabRowGroupBuilder[]{rowStateGroup, rowItemGroup}).columnGroups(new CrosstabColumnGroupBuilder[]{columnYearGroup, columnQuarterGroup}).measures(new CrosstabMeasureBuilder[]{quantityMeasure, unitPriceMeasure});
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", Date.class)})).setPageFormat(PageType.A3, PageOrientation.LANDSCAPE)).setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("SalesCrosstab")})).summary(new ComponentBuilder[]{crosstab})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.data.createDataSource());
        return report;
    }

    private class QuarterExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private QuarterExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)reportParameters.getValue("orderdate"));
            return "Q" + (c.get(2) / 3 + 1);
        }
    }

    private class YearExpression
    extends AbstractSimpleExpression<Integer> {
        private static final long serialVersionUID = 1L;

        private YearExpression() {
        }

        public Integer evaluate(ReportParameters reportParameters) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)reportParameters.getValue("orderdate"));
            return c.get(1);
        }
    }
}

