/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.invoice;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.complex.invoice.Customer;
import cn.myapps.report.examples.complex.invoice.InvoiceData;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListCellBuilder;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.dynamicreports.report.exception.DRException;

public class InvoiceDesign {
    private InvoiceData data = new InvoiceData();
    private AggregationSubtotalBuilder<BigDecimal> totalSum;

    public static void main(String[] args) {
        InvoiceDesign design = new InvoiceDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        StyleBuilder columnStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.columnStyle).setBorder(DynamicReports.stl.pen1Point());
        StyleBuilder subtotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).bold();
        StyleBuilder shippingStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.boldStyle).setHorizontalTextAlignment(HorizontalTextAlignment.RIGHT);
        TextColumnBuilder rowNumberColumn = (TextColumnBuilder)((TextColumnBuilder)DynamicReports.col.reportRowNumberColumn().setFixedColumns(Integer.valueOf(2))).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        TextColumnBuilder descriptionColumn = (TextColumnBuilder)DynamicReports.col.column("Description", "description", (DRIDataType)DynamicReports.type.stringType()).setFixedWidth(Integer.valueOf(250));
        TextColumnBuilder quantityColumn = (TextColumnBuilder)DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit Price", "unitprice", (DRIDataType)Templates.currencyType);
        TextColumnBuilder taxColumn = (TextColumnBuilder)DynamicReports.col.column("Tax", (DRIExpression)DynamicReports.exp.text("20%")).setFixedColumns(Integer.valueOf(3));
        TextColumnBuilder priceColumn = (TextColumnBuilder)((TextColumnBuilder)unitPriceColumn.multiply(quantityColumn).setTitle("Price")).setDataType((DRIDataType)Templates.currencyType);
        TextColumnBuilder vatColumn = (TextColumnBuilder)((TextColumnBuilder)priceColumn.multiply((Number)this.data.getInvoice().getTax()).setTitle("VAT")).setDataType((DRIDataType)Templates.currencyType);
        TextColumnBuilder totalColumn = (TextColumnBuilder)((TextColumnBuilder)((TextColumnBuilder)((TextColumnBuilder)priceColumn.add(vatColumn).setTitle("Total Price")).setDataType((DRIDataType)Templates.currencyType)).setRows(Integer.valueOf(2))).setStyle((ReportStyleBuilder)subtotalStyle);
        this.totalSum = (AggregationSubtotalBuilder)((AggregationSubtotalBuilder)DynamicReports.sbt.sum((ValueColumnBuilder)totalColumn).setLabel("Total:")).setLabelStyle((ReportStyleBuilder)Templates.boldStyle);
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).setColumnStyle((ReportStyleBuilder)columnStyle)).setSubtotalStyle((ReportStyleBuilder)subtotalStyle)).columns(new ColumnBuilder[]{rowNumberColumn, descriptionColumn, quantityColumn, unitPriceColumn, totalColumn, priceColumn, taxColumn, vatColumn})).columnGrid(new ColumnGridComponentBuilder[]{rowNumberColumn, descriptionColumn, quantityColumn, unitPriceColumn, DynamicReports.grid.horizontalColumnGridList().add(new ColumnGridComponentBuilder[]{totalColumn}).newRow().add(new ColumnGridComponentBuilder[]{priceColumn, taxColumn, vatColumn})})).subtotalsAtSummary(new SubtotalBuilder[]{this.totalSum, DynamicReports.sbt.sum((ValueColumnBuilder)priceColumn), DynamicReports.sbt.sum((ValueColumnBuilder)vatColumn)})).title(new ComponentBuilder[]{Templates.createTitleComponent("Invoice No.: " + this.data.getInvoice().getId()), DynamicReports.cmp.horizontalList().setStyle((ReportStyleBuilder)DynamicReports.stl.style(Integer.valueOf(10))).setGap(Integer.valueOf(50)).add(new HorizontalListCellBuilder[]{DynamicReports.cmp.hListCell(this.createCustomerComponent("Bill To", this.data.getInvoice().getBillTo())).heightFixedOnTop(), DynamicReports.cmp.hListCell(this.createCustomerComponent("Ship To", this.data.getInvoice().getShipTo())).heightFixedOnTop()}), DynamicReports.cmp.verticalGap(10)})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).summary(new ComponentBuilder[]{DynamicReports.cmp.text((Number)this.data.getInvoice().getShipping()).setValueFormatter((DRIValueFormatter)Templates.createCurrencyValueFormatter("Shipping:")).setStyle((ReportStyleBuilder)shippingStyle), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.text("Payment terms: 30 days").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle), DynamicReports.cmp.text((DRIExpression)new TotalPaymentExpression()).setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle)}), DynamicReports.cmp.verticalGap(30), DynamicReports.cmp.text("Thank you for your business").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle)})).setDataSource(this.data.createDataSource());
        return report;
    }

    private ComponentBuilder<?, ?> createCustomerComponent(String label, Customer customer) {
        HorizontalListBuilder list = DynamicReports.cmp.horizontalList().setBaseStyle((ReportStyleBuilder)((StyleBuilder)DynamicReports.stl.style().setTopBorder(DynamicReports.stl.pen1Point())).setLeftPadding(Integer.valueOf(10)));
        this.addCustomerAttribute(list, "Name", customer.getName());
        this.addCustomerAttribute(list, "Address", customer.getAddress());
        this.addCustomerAttribute(list, "City", customer.getCity());
        this.addCustomerAttribute(list, "Email", customer.getEmail());
        return DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)Templates.boldStyle), list});
    }

    private void addCustomerAttribute(HorizontalListBuilder list, String label, String value) {
        if (value != null) {
            list.add(new ComponentBuilder[]{DynamicReports.cmp.text(label + ":").setFixedColumns(Integer.valueOf(8)).setStyle((ReportStyleBuilder)Templates.boldStyle), DynamicReports.cmp.text(value)}).newRow();
        }
    }

    private class TotalPaymentExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private TotalPaymentExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            BigDecimal total = (BigDecimal)reportParameters.getValue((DRIValue)InvoiceDesign.this.totalSum);
            BigDecimal shipping = total.add(InvoiceDesign.this.data.getInvoice().getShipping());
            return "Total payment: " + Templates.currencyType.valueToString(shipping, reportParameters.getLocale());
        }
    }
}

