/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.invoice;

import cn.myapps.report.examples.complex.invoice.Customer;
import cn.myapps.report.examples.complex.invoice.Invoice;
import cn.myapps.report.examples.complex.invoice.Item;
import java.math.BigDecimal;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class InvoiceData {
    private Invoice invoice = this.createInvoice();

    private Invoice createInvoice() {
        Invoice invoice = new Invoice();
        invoice.setId(5);
        invoice.setShipping(new BigDecimal(10));
        invoice.setTax(0.2);
        invoice.setBillTo(this.createCustomer("Mary Patterson", "151 Pompton St.", "Washington", "mpatterson@noemail.com"));
        invoice.setShipTo(this.createCustomer("Peter Marsh", "23 Baden Av.", "New York", null));
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(this.createItem("Notebook", 1, new BigDecimal(1000)));
        items.add(this.createItem("DVD", 5, new BigDecimal(40)));
        items.add(this.createItem("Book", 2, new BigDecimal(10)));
        items.add(this.createItem("Phone", 1, new BigDecimal(200)));
        invoice.setItems(items);
        return invoice;
    }

    private Customer createCustomer(String name, String address, String city, String email) {
        Customer customer = new Customer();
        customer.setName(name);
        customer.setAddress(address);
        customer.setCity(city);
        customer.setEmail(email);
        return customer;
    }

    private Item createItem(String description, Integer quantity, BigDecimal unitprice) {
        Item item = new Item();
        item.setDescription(description);
        item.setQuantity(quantity);
        item.setUnitprice(unitprice);
        return item;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public JRDataSource createDataSource() {
        return new JRBeanCollectionDataSource(this.invoice.getItems());
    }
}

