/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.complex.dynamicreport;

import cn.myapps.report.examples.Templates;
import cn.myapps.report.examples.complex.dynamicreport.DynamicColumn;
import cn.myapps.report.examples.complex.dynamicreport.DynamicReport;
import cn.myapps.report.examples.complex.dynamicreport.DynamicReportData;
import java.util.HashMap;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.PageXofYBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.exception.DRException;

public class DynamicReportDesign {
    private DynamicReportData data = new DynamicReportData();

    public static void main(String[] args) {
        DynamicReportDesign design = new DynamicReportDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        ((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("DynamicReport")});
        DynamicReport dynamicReport = this.data.getDynamicReport();
        List<DynamicColumn> columns = dynamicReport.getColumns();
        HashMap<String, TextColumnBuilder> drColumns = new HashMap<String, TextColumnBuilder>();
        for (DynamicColumn column : columns) {
            TextColumnBuilder drColumn = DynamicReports.col.column(column.getTitle(), column.getName(), DynamicReports.type.detectType(column.getType()));
            if (column.getPattern() != null) {
                drColumn.setPattern(column.getPattern());
            }
            if (column.getHorizontalTextAlignment() != null) {
                drColumn.setHorizontalTextAlignment(column.getHorizontalTextAlignment());
            }
            drColumns.put(column.getName(), drColumn);
            report.columns(new ColumnBuilder[]{drColumn});
        }
        for (String group : dynamicReport.getGroups()) {
            ColumnGroupBuilder group2 = DynamicReports.grp.group((ValueColumnBuilder)drColumns.get(group));
            report.groupBy(new GroupBuilder[]{group2});
            for (String subtotal : dynamicReport.getSubtotals()) {
                report.subtotalsAtGroupFooter((GroupBuilder)group2, new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)drColumns.get(subtotal))});
            }
        }
        for (String subtotal : dynamicReport.getSubtotals()) {
            report.subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.sum((ValueColumnBuilder)drColumns.get(subtotal))});
        }
        if (dynamicReport.getTitle() != null) {
            TextFieldBuilder title = ((TextFieldBuilder)DynamicReports.cmp.text(dynamicReport.getTitle()).setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle)).setHorizontalTextAlignment(HorizontalTextAlignment.CENTER);
            report.addTitle(new ComponentBuilder[]{title});
        }
        if (dynamicReport.isShowPageNumber()) {
            PageXofYBuilder pageXofY = (PageXofYBuilder)DynamicReports.cmp.pageXofY().setStyle((ReportStyleBuilder)Templates.boldCenteredStyle);
            report.addPageFooter(new ComponentBuilder[]{pageXofY});
        }
        report.setDataSource(this.data.createDataSource());
        return report;
    }
}

