/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.columngrid;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ComponentColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class VerticalValuesReport {
    public VerticalValuesReport() {
        this.build();
    }

    public static void main(String[] args) {
        new VerticalValuesReport();
    }

    private void build() {
        StyleBuilder nameStyle = (StyleBuilder)DynamicReports.stl.style().bold();
        StyleBuilder valueStyle = (StyleBuilder)DynamicReports.stl.style().setHorizontalTextAlignment(HorizontalTextAlignment.LEFT);
        FieldBuilder itemField = DynamicReports.field((String)"item", (DRIDataType)DynamicReports.type.stringType());
        FieldBuilder quantityField = DynamicReports.field((String)"quantity", (DRIDataType)DynamicReports.type.integerType());
        FieldBuilder unitPriceField = DynamicReports.field((String)"unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        FieldBuilder orderDateField = DynamicReports.field((String)"orderdate", (DRIDataType)DynamicReports.type.dateType());
        VerticalListBuilder nameList = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text("Item:").setStyle((ReportStyleBuilder)nameStyle), DynamicReports.cmp.text("Quantity:").setStyle((ReportStyleBuilder)nameStyle), DynamicReports.cmp.text("Unit price:").setStyle((ReportStyleBuilder)nameStyle), DynamicReports.cmp.text("Order date:").setStyle((ReportStyleBuilder)nameStyle)});
        VerticalListBuilder valueList = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(itemField).setStyle((ReportStyleBuilder)valueStyle), DynamicReports.cmp.text(quantityField).setStyle((ReportStyleBuilder)valueStyle), DynamicReports.cmp.text(unitPriceField).setStyle((ReportStyleBuilder)valueStyle), DynamicReports.cmp.text(orderDateField).setStyle((ReportStyleBuilder)valueStyle)});
        ComponentColumnBuilder nameColumn = DynamicReports.col.componentColumn("Name", (ComponentBuilder)nameList);
        ComponentColumnBuilder valueColumn = DynamicReports.col.componentColumn("Value", (ComponentBuilder)valueList);
        AggregationSubtotalBuilder unitPriceSum = (AggregationSubtotalBuilder)DynamicReports.sbt.sum(unitPriceField, (ColumnBuilder)valueColumn).setLabel("Unit price sum =");
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).setPageFormat(PageType.A5)).fields(new FieldBuilder[]{itemField, quantityField, unitPriceField, orderDateField})).columns(new ColumnBuilder[]{nameColumn, valueColumn})).subtotalsAtSummary(new SubtotalBuilder[]{unitPriceSum})).title(new ComponentBuilder[]{Templates.createTitleComponent("VerticalValues")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Notebook", new Date(), 1, new BigDecimal(500)});
        dataSource.add(new Object[]{"Book", new Date(), 4, new BigDecimal(25)});
        dataSource.add(new Object[]{"PDA", new Date(), 2, new BigDecimal(120)});
        return dataSource;
    }
}

