/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.column;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.PercentageColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class PercentageColumnsReport {
    private FieldBuilder<BigDecimal> unitPriceField;

    public PercentageColumnsReport() {
        this.build();
    }

    public static void main(String[] args) {
        new PercentageColumnsReport();
    }

    private void build() {
        try {
            this.unitPriceField = DynamicReports.field((String)"unitprice", BigDecimal.class);
            TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
            TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
            PercentageColumnBuilder quantityPercColumn = DynamicReports.col.percentageColumn("Quantity [%]", (ValueColumnBuilder)quantityColumn);
            PercentageColumnBuilder unitPricePercColumn = DynamicReports.col.percentageColumn("Unit price [%]", this.unitPriceField);
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{this.unitPriceField})).columns(new ColumnBuilder[]{itemColumn, quantityColumn, quantityPercColumn, unitPricePercColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("PercentageColumns")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 3, new BigDecimal(11)});
        dataSource.add(new Object[]{"Book", 1, new BigDecimal(15)});
        dataSource.add(new Object[]{"Book", 5, new BigDecimal(10)});
        dataSource.add(new Object[]{"Book", 8, new BigDecimal(9)});
        return dataSource;
    }
}

