/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.column;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.subtotal.SubtotalBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ConversionColumnReport {
    public ConversionColumnReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ConversionColumnReport();
    }

    private void build() {
        try {
            TextColumnBuilder orderDateColumn1 = (TextColumnBuilder)DynamicReports.col.column("Order date", (DRIExpression)new OrderDateColumn1()).setDataType((DRIDataType)DynamicReports.type.dateType());
            TextColumnBuilder orderDateColumn2 = (TextColumnBuilder)DynamicReports.col.column("Order date", (DRIExpression)new OrderDateColumn2()).setDataType((DRIDataType)DynamicReports.type.dateType());
            TextColumnBuilder quantityColumn1 = (TextColumnBuilder)DynamicReports.col.column("Quantity", (DRIExpression)new QuantityColumn1()).setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
            TextColumnBuilder quantityColumn2 = (TextColumnBuilder)DynamicReports.col.column("Quantity", (DRIExpression)new QuantityColumn2()).setDataType((DRIDataType)DynamicReports.type.bigDecimalType());
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", String.class), DynamicReports.field((String)"quantity", String.class)})).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), orderDateColumn1, orderDateColumn2, quantityColumn1, quantityColumn2})).title(new ComponentBuilder[]{Templates.createTitleComponent("ConversionColumn")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).subtotalsAtSummary(new SubtotalBuilder[]{DynamicReports.sbt.min((ValueColumnBuilder)orderDateColumn1), DynamicReports.sbt.min((ValueColumnBuilder)orderDateColumn2), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn1), DynamicReports.sbt.sum((ValueColumnBuilder)quantityColumn2)})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity"});
        dataSource.add(new Object[]{"Notebook", "1/1/2010", "100.9"});
        dataSource.add(new Object[]{"Notebook", "2/2/2010", "100.2"});
        return dataSource;
    }

    private class QuantityColumn2
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private QuantityColumn2() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            try {
                return (BigDecimal)DynamicReports.type.bigDecimalType().stringToValue("quantity", reportParameters);
            }
            catch (DRException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class QuantityColumn1
    extends AbstractSimpleExpression<BigDecimal> {
        private static final long serialVersionUID = 1L;

        private QuantityColumn1() {
        }

        public BigDecimal evaluate(ReportParameters reportParameters) {
            String value = (String)reportParameters.getValue("quantity");
            try {
                Number number = new DecimalFormat("#,###.##", new DecimalFormatSymbols(reportParameters.getLocale())).parse(value);
                return new BigDecimal(number.doubleValue());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class OrderDateColumn2
    extends AbstractSimpleExpression<Date> {
        private static final long serialVersionUID = 1L;

        private OrderDateColumn2() {
        }

        public Date evaluate(ReportParameters reportParameters) {
            try {
                return (Date)DynamicReports.type.dateType().stringToValue("orderdate", reportParameters);
            }
            catch (DRException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class OrderDateColumn1
    extends AbstractSimpleExpression<Date> {
        private static final long serialVersionUID = 1L;

        private OrderDateColumn1() {
        }

        public Date evaluate(ReportParameters reportParameters) {
            String value = (String)reportParameters.getValue("orderdate");
            try {
                return new SimpleDateFormat("MM/dd/yyyy", reportParameters.getLocale()).parse(value);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

