/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.column;

import cn.myapps.report.examples.Templates;
import java.io.InputStream;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.ImageBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ComponentColumnReport {
    public ComponentColumnReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ComponentColumnReport();
    }

    private void build() {
        try {
            ImageBuilder image = (ImageBuilder)DynamicReports.cmp.image((DRIExpression)new ImageExpression()).setFixedDimension(Integer.valueOf(48), Integer.valueOf(48));
            HorizontalListBuilder itemComponent = DynamicReports.cmp.horizontalList(new ComponentBuilder[]{image, DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text((DRIExpression)new ItemExpression()), DynamicReports.bcode.ean128((DRIExpression)new BarcodeExpression()).setFixedHeight(Integer.valueOf(24))})});
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{DynamicReports.field((String)"image", String.class), DynamicReports.field((String)"barcode", String.class)})).columns(new ColumnBuilder[]{DynamicReports.col.componentColumn("Image", (ComponentBuilder)image), DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.componentColumn("Item", (ComponentBuilder)itemComponent)})).title(new ComponentBuilder[]{Templates.createTitleComponent("ComponentColumn")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "image", "barcode"});
        dataSource.add(new Object[]{"PDA", "pda", "100264832717658"});
        dataSource.add(new Object[]{"Camera", "camera", "100364875790352"});
        dataSource.add(new Object[]{"Camera", "camera", "100764935316351"});
        dataSource.add(new Object[]{"USB", "usb", "100864565780343"});
        dataSource.add(new Object[]{"PDA", "pda", "100264865712551"});
        dataSource.add(new Object[]{"USB", "usb", "100268834723431"});
        return dataSource;
    }

    public class BarcodeExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        public String evaluate(ReportParameters reportParameters) {
            return (String)reportParameters.getValue("barcode");
        }
    }

    public class ItemExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        public String evaluate(ReportParameters reportParameters) {
            return (String)reportParameters.getValue("item");
        }
    }

    public class ImageExpression
    extends AbstractSimpleExpression<InputStream> {
        private static final long serialVersionUID = 1L;

        public InputStream evaluate(ReportParameters reportParameters) {
            return Templates.class.getResourceAsStream("images/" + reportParameters.getValue("image") + ".png");
        }
    }
}

