/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chartcustomization;

import cn.myapps.report.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.VariableBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.Bar3DChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.Evaluation;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupCountChartReport {
    public GroupCountChartReport() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupCountChartReport();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        Bar3DChartBuilder chart1 = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setFixedHeight(Integer.valueOf(180))).setCategory((ValueColumnBuilder)countryColumn)).series(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((DRIExpression)DynamicReports.exp.number((Number)1)).setLabel("Items (group count)")})).setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel("Country"));
        VariableBuilder itemVariable = DynamicReports.variable((ValueColumnBuilder)itemColumn, (Calculation)Calculation.DISTINCT_COUNT);
        itemVariable.setResetType(Evaluation.FIRST_GROUP);
        Bar3DChartBuilder chart2 = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setFixedHeight(Integer.valueOf(180))).setCategory((ValueColumnBuilder)countryColumn)).series(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie(itemVariable).setLabel("Items (group distinct count)")})).setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel("Country"));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{countryColumn, itemColumn, quantityColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupCountChart")})).groupBy(new GroupBuilder[]{DynamicReports.grp.group((ValueColumnBuilder)countryColumn)})).summary(new ComponentBuilder[]{DynamicReports.cmp.horizontalList(new ComponentBuilder[]{chart1, chart2})})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "quantity"});
        dataSource.add(new Object[]{"USA", "Tablet", 170});
        dataSource.add(new Object[]{"USA", "Tablet", 80});
        dataSource.add(new Object[]{"USA", "Laptop", 90});
        dataSource.add(new Object[]{"USA", "Smartphone", 120});
        dataSource.add(new Object[]{"Canada", "Tablet", 120});
        dataSource.add(new Object[]{"Canada", "Laptop", 150});
        return dataSource;
    }
}

