/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chartcustomization;

import cn.myapps.report.examples.Templates;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupChartReport2 {
    public GroupChartReport2() {
        this.build();
    }

    public static void main(String[] args) {
        new GroupChartReport2();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        TextColumnBuilder yearColumn = DynamicReports.col.column("Year", "year", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder stockColumn = DynamicReports.col.column("Stock", "stock", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        BarChartBuilder chart1 = (BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().setTitle((DRIExpression)new ChartTitleExpression((TextColumnBuilder<String>)stockColumn))).setTitleFont(boldFont)).setCategory((ValueColumnBuilder)yearColumn)).series(new AbstractCategoryChartSerieBuilder[]{(AbstractCategoryChartSerieBuilder)DynamicReports.cht.serie((ValueColumnBuilder)quantityColumn).setSeries((ValueColumnBuilder)itemColumn)});
        ColumnGroupBuilder stockGroup = (ColumnGroupBuilder)((ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)stockColumn).setHeaderLayout(GroupHeaderLayout.EMPTY)).footer(new ComponentBuilder[]{chart1});
        JasperReportBuilder subReport = ((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().sortBy(new TextColumnBuilder[]{stockColumn})).groupBy(new GroupBuilder[]{stockGroup})).setDataSource(this.createDataSource());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{yearColumn, stockColumn, itemColumn, quantityColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupChart2")})).summary(new ComponentBuilder[]{DynamicReports.cmp.subreport(subReport)})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"year", "stock", "item", "quantity"});
        dataSource.add(new Object[]{"2010", "Stock1", "Tablet", 80});
        dataSource.add(new Object[]{"2010", "Stock1", "Smartphone", 40});
        dataSource.add(new Object[]{"2010", "Stock2", "Tablet", 70});
        dataSource.add(new Object[]{"2010", "Stock2", "Smartphone", 250});
        dataSource.add(new Object[]{"2011", "Stock1", "Tablet", 40});
        dataSource.add(new Object[]{"2011", "Stock1", "Smartphone", 90});
        dataSource.add(new Object[]{"2011", "Stock2", "Tablet", 180});
        dataSource.add(new Object[]{"2011", "Stock2", "Smartphone", 150});
        return dataSource;
    }

    private class ChartTitleExpression
    extends AbstractComplexExpression<String> {
        private static final long serialVersionUID = 1L;

        public ChartTitleExpression(TextColumnBuilder<String> stockColumn) {
            this.addExpression(stockColumn);
        }

        public String evaluate(List<?> values, ReportParameters reportParameters) {
            return (String)values.get(0);
        }
    }
}

