/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chartcustomization;

import cn.myapps.report.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.AbstractScriptlet;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.charts.util.DrawChartRendererImpl;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.renderers.Renderable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class CustomChartReport {
    private DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();

    public CustomChartReport() {
        this.build();
    }

    public static void main(String[] args) {
        new CustomChartReport();
    }

    private void build() {
        TextColumnBuilder seriesColumn = DynamicReports.col.column("Series", "series", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder categoryColumn = DynamicReports.col.column("Category", "category", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder meanColumn = DynamicReports.col.column("Mean", "mean", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder medianColumn = DynamicReports.col.column("Median", "median", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder q1Column = DynamicReports.col.column("Q1", "q1", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder q3Column = DynamicReports.col.column("Q3", "q3", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder minRegularValueColumn = DynamicReports.col.column("Min regular value", "minregularvalue", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder maxRegularValueColumn = DynamicReports.col.column("Max regular value", "maxregularvalue", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder minOutlierColumn = DynamicReports.col.column("Min outlier", "minoutlier", (DRIDataType)DynamicReports.type.doubleType());
        TextColumnBuilder maxOutlierColumn = DynamicReports.col.column("Max outlier", "maxoutlier", (DRIDataType)DynamicReports.type.doubleType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).scriptlets(new DRIScriptlet[]{new ReportScriptlet()})).columns(new ColumnBuilder[]{seriesColumn, categoryColumn, meanColumn, medianColumn, q1Column, q3Column, minRegularValueColumn, maxRegularValueColumn, minOutlierColumn, maxOutlierColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("CustomChart")})).summary(new ComponentBuilder[]{DynamicReports.cmp.image((DRIExpression)new ChartExpression()).setFixedHeight(Integer.valueOf(300))})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"series", "category", "mean", "median", "q1", "q3", "minregularvalue", "maxregularvalue", "minoutlier", "maxoutlier"});
        dataSource.add(new Object[]{"Series 0", "Category 0", 10.55, 10.75, 6.05, 14.76, 1.93, 18.51, 1.93, 18.51});
        dataSource.add(new Object[]{"Series 0", "Category 1", 8.92, 7.78, 4.32, 13.07, 1.01, 19.89, 1.01, 19.89});
        dataSource.add(new Object[]{"Series 0", "Category 2", 12.88, 14.19, 8.72, 17.23, 2.48, 19.74, 2.48, 19.74});
        dataSource.add(new Object[]{"Series 0", "Category 3", 8.87, 8.68, 3.55, 14.26, 0.13, 16.87, 0.13, 16.87});
        dataSource.add(new Object[]{"Series 0", "Category 4", 9.05, 8.33, 3.61, 14.28, 0.46, 19.86, 0.46, 19.86});
        dataSource.add(new Object[]{"Series 1", "Category 0", 10.11, 10.69, 3.96, 13.93, 0.58, 19.9, 0.58, 19.9});
        dataSource.add(new Object[]{"Series 1", "Category 1", 10.43, 9.13, 5.72, 14.46, 2.25, 19.79, 2.25, 19.79});
        dataSource.add(new Object[]{"Series 1", "Category 2", 10.04, 8.71, 6.32, 15.15, 0.04, 19.15, 0.04, 19.15});
        dataSource.add(new Object[]{"Series 1", "Category 3", 10.67, 10.56, 7.14, 14.76, 0.27, 16.99, 0.27, 16.99});
        dataSource.add(new Object[]{"Series 1", "Category 4", 10.91, 10.63, 7.18, 15.51, 2.3, 19.53, 2.3, 19.53});
        return dataSource;
    }

    private class ChartExpression
    extends AbstractSimpleExpression<Renderable> {
        private static final long serialVersionUID = 1L;

        private ChartExpression() {
        }

        public Renderable evaluate(ReportParameters reportParameters) {
            JFreeChart chart = ChartFactory.createBoxAndWhiskerChart((String)"Box and Whisker chart", (String)"Category", (String)"Value", (BoxAndWhiskerCategoryDataset)CustomChartReport.this.dataset, (boolean)true);
            return new DrawChartRendererImpl(chart, null);
        }
    }

    private class ReportScriptlet
    extends AbstractScriptlet {
        private ReportScriptlet() {
        }

        public void afterDetailEval(ReportParameters reportParameters) {
            super.afterDetailEval(reportParameters);
            String series = (String)reportParameters.getValue("series");
            String category = (String)reportParameters.getValue("category");
            Double mean = (Double)reportParameters.getValue("mean");
            Double median = (Double)reportParameters.getValue("median");
            Double q1 = (Double)reportParameters.getValue("q1");
            Double q3 = (Double)reportParameters.getValue("q3");
            Double minRegularValue = (Double)reportParameters.getValue("minregularvalue");
            Double maxRegularValue = (Double)reportParameters.getValue("maxregularvalue");
            Double minOutlier = (Double)reportParameters.getValue("minoutlier");
            Double maxOutlier = (Double)reportParameters.getValue("maxoutlier");
            BoxAndWhiskerItem item = new BoxAndWhiskerItem((Number)mean, (Number)median, (Number)q1, (Number)q3, (Number)minRegularValue, (Number)maxRegularValue, (Number)minOutlier, (Number)maxOutlier, null);
            CustomChartReport.this.dataset.add(item, (Comparable)((Object)series), (Comparable)((Object)category));
        }
    }
}

