/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chartcustomization;

import cn.myapps.report.examples.Templates;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.renderer.category.BarRenderer;

public class ChartCustomizerReport {
    public ChartCustomizerReport() {
        this.build();
    }

    public static void main(String[] args) {
        new ChartCustomizerReport();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("ChartCustomizer")})).summary(new ComponentBuilder[]{((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().customizers(new DRIChartCustomizer[]{new ChartCustomizer()})).setTitle("Bar chart")).setTitleFont(boldFont)).setCategory((ValueColumnBuilder)itemColumn)).series(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)quantityColumn), DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn)})).setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel("Item"))})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Tablet", 350, new BigDecimal(300)});
        dataSource.add(new Object[]{"Laptop", 300, new BigDecimal(500)});
        dataSource.add(new Object[]{"Smartphone", 450, new BigDecimal(250)});
        return dataSource;
    }

    private class ChartCustomizer
    implements DRIChartCustomizer,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ChartCustomizer() {
        }

        public void customize(JFreeChart chart, ReportParameters reportParameters) {
            BarRenderer renderer = (BarRenderer)chart.getCategoryPlot().getRenderer();
            renderer.setShadowPaint((Paint)Color.LIGHT_GRAY);
            renderer.setShadowVisible(true);
            CategoryAxis domainAxis = chart.getCategoryPlot().getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
        }
    }
}

