/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chart;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.PieChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class PieChartReport {
    public PieChartReport() {
        this.build();
    }

    public static void main(String[] args) {
        new PieChartReport();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("PieChart")})).summary(new ComponentBuilder[]{((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)DynamicReports.cht.pieChart().setTitle("Pie chart")).setTitleFont(boldFont)).setKey((ValueColumnBuilder)itemColumn)).series(new CategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn)})})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Tablet", 350, new BigDecimal(300)});
        dataSource.add(new Object[]{"Laptop", 300, new BigDecimal(500)});
        dataSource.add(new Object[]{"Smartphone", 450, new BigDecimal(250)});
        return dataSource;
    }
}

