/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.chart;

import cn.myapps.report.examples.Templates;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.LineChartBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.constant.AxisPosition;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class MultiAxisChartReport {
    public MultiAxisChartReport() {
        this.build();
    }

    public static void main(String[] args) {
        new MultiAxisChartReport();
    }

    private void build() {
        FieldBuilder dateField = DynamicReports.field((String)"date", (DRIDataType)DynamicReports.type.dateType());
        FieldBuilder stock1Field = DynamicReports.field((String)"stock1", (DRIDataType)DynamicReports.type.integerType());
        FieldBuilder stock2Field = DynamicReports.field((String)"stock2", (DRIDataType)DynamicReports.type.integerType());
        CategoryChartSerieBuilder stock1Serie = (CategoryChartSerieBuilder)DynamicReports.cht.serie(stock1Field).setLabel("Stock1");
        CategoryChartSerieBuilder stock2Serie = (CategoryChartSerieBuilder)DynamicReports.cht.serie(stock2Field).setLabel("Stock2");
        LineChartBuilder chart1 = (LineChartBuilder)((LineChartBuilder)((LineChartBuilder)DynamicReports.cht.lineChart().setCategory((DRIExpression)new CategoryExpression())).series(new AbstractCategoryChartSerieBuilder[]{stock1Serie})).setValueAxisFormat(DynamicReports.cht.axisFormat().setLabel("Stock1"));
        BarChartBuilder chart2 = (BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().setCategory((DRIExpression)new CategoryExpression())).series(new AbstractCategoryChartSerieBuilder[]{stock2Serie})).setValueAxisFormat(DynamicReports.cht.axisFormat().setLabel("Stock2"));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{dateField})).title(new ComponentBuilder[]{Templates.createTitleComponent("MultiAxisChart"), DynamicReports.cht.multiAxisChart(new AbstractBaseChartBuilder[]{chart1, chart2}), DynamicReports.cht.multiAxisChart().addChart((AbstractBaseChartBuilder)chart1, AxisPosition.LEFT_OR_TOP).addChart((AbstractBaseChartBuilder)chart2, AxisPosition.RIGHT_OR_BOTTOM)})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"date", "stock1", "stock2"});
        dataSource.add(new Object[]{this.toDate(2010, 1), 25, 300});
        dataSource.add(new Object[]{this.toDate(2010, 2), 11, 450});
        dataSource.add(new Object[]{this.toDate(2010, 3), 17, 280});
        dataSource.add(new Object[]{this.toDate(2010, 4), 15, 620});
        dataSource.add(new Object[]{this.toDate(2010, 5), 30, 400});
        dataSource.add(new Object[]{this.toDate(2010, 6), 8, 320});
        dataSource.add(new Object[]{this.toDate(2010, 7), 25, 490});
        return dataSource;
    }

    private Date toDate(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        return c.getTime();
    }

    private class CategoryExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private CategoryExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            return DynamicReports.type.dateYearToMonthType().valueToString("date", reportParameters);
        }
    }
}

