/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.examples.adhoc;

import cn.myapps.report.examples.Templates;
import java.math.BigDecimal;
import java.util.Date;
import net.sf.dynamicreports.adhoc.AdhocManager;
import net.sf.dynamicreports.adhoc.configuration.AdhocCalculation;
import net.sf.dynamicreports.adhoc.configuration.AdhocColumn;
import net.sf.dynamicreports.adhoc.configuration.AdhocConfiguration;
import net.sf.dynamicreports.adhoc.configuration.AdhocGroup;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.adhoc.configuration.AdhocSort;
import net.sf.dynamicreports.adhoc.configuration.AdhocSubtotal;
import net.sf.dynamicreports.adhoc.report.AdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.report.DefaultAdhocReportCustomizer;
import net.sf.dynamicreports.adhoc.transformation.AdhocToXmlTransform;
import net.sf.dynamicreports.adhoc.transformation.XmlToAdhocTransform;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.ReportBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class AdhocCustomizerReport {
    public AdhocCustomizerReport() {
        this.build();
    }

    public static void main(String[] args) {
        new AdhocCustomizerReport();
    }

    private void build() {
        AdhocManager adhocManager = AdhocManager.getInstance((AdhocToXmlTransform)new AdhocToXmlTransform(), (XmlToAdhocTransform)new XmlToAdhocTransform());
        AdhocConfiguration configuration = new AdhocConfiguration();
        AdhocReport report = new AdhocReport();
        configuration.setReport(report);
        AdhocColumn column = new AdhocColumn();
        column.setName("quantity");
        report.addColumn(column);
        column = new AdhocColumn();
        column.setName("unitprice");
        report.addColumn(column);
        AdhocGroup group = new AdhocGroup();
        group.setName("item");
        report.addGroup(group);
        AdhocSubtotal subtotal = new AdhocSubtotal();
        subtotal.setName("quantity");
        subtotal.setCalculation(AdhocCalculation.COUNT);
        report.addSubtotal(subtotal);
        subtotal = new AdhocSubtotal();
        subtotal.setCalculation(AdhocCalculation.SUM);
        subtotal.setName("unitprice");
        report.addSubtotal(subtotal);
        AdhocSort sort = new AdhocSort();
        sort.setName("item");
        report.addSort(sort);
        try {
            JasperReportBuilder reportBuilder = adhocManager.createReport(configuration.getReport(), (AdhocReportCustomizer)new ReportCustomizer());
            reportBuilder.setDataSource(this.createDataSource());
            reportBuilder.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        int i;
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        for (i = 0; i < 15; ++i) {
            dataSource.add(new Object[]{"Book", new Date(), (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
        }
        for (i = 0; i < 20; ++i) {
            dataSource.add(new Object[]{"PDA", new Date(), (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
        }
        return dataSource;
    }

    private class ReportCustomizer
    extends DefaultAdhocReportCustomizer {
        private ReportCustomizer() {
        }

        public void customize(ReportBuilder<?> report, AdhocReport adhocReport) throws DRException {
            super.customize(report, adhocReport);
            report.setTemplate(Templates.reportTemplate);
            report.title(new ComponentBuilder[]{Templates.createTitleComponent("AdhocCustomizer")});
            report.pageFooter(new ComponentBuilder[]{Templates.footerComponent});
        }

        protected DRIDataType<?, ?> getFieldType(String name) {
            if (name.equals("item")) {
                return DynamicReports.type.stringType();
            }
            if (name.equals("orderdate")) {
                return DynamicReports.type.dateType();
            }
            if (name.equals("quantity")) {
                return DynamicReports.type.integerType();
            }
            if (name.equals("unitprice")) {
                return DynamicReports.type.bigDecimalType();
            }
            return super.getFieldType(name);
        }

        protected String getFieldLabel(String name) {
            if (name.equals("item")) {
                return "Item";
            }
            if (name.equals("orderdate")) {
                return "Order date";
            }
            if (name.equals("quantity")) {
                return "Quantity";
            }
            if (name.equals("unitprice")) {
                return "Unit price";
            }
            return name;
        }
    }
}

