/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.report.engine;

import cn.myapps.common.Environment;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.report.service.ReportDesignTimeServiceImpl;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.report.examples.Templates;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.report.model.DRDataSource;
import cn.myapps.runtime.report.model.JRBeanCollectionDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.AbstractJasperExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPdfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsExporterBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.QueryBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang.StringUtils;

public class ReportEngine {
    private static ReportEngine INSTANCE;

    public static ReportEngine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReportEngine();
        }
        return INSTANCE;
    }

    private JRDataSource createViewDataSource(Report report, ParamsTable params, IUser user) throws Exception {
        return null;
    }

    private QueryBuilder createSqlDataSource(Report report, ParamsTable params, IUser user) throws Exception {
        if (!StringUtil.isBlank((String)report.getDataSourceSqlScript())) {
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
            runner.initBSFManager(null, params, user, new ArrayList());
            Object result = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), report.getDataSourceSqlScript());
            if (result instanceof String) {
                String sql = (String)result;
                QueryBuilder query = DynamicReports.query((String)sql, (String)"sql");
                return query;
            }
            throw new Exception("Report[" + report.getName() + "]\u811a\u672c\u8fd0\u7b97\u7ed3\u679c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8fd4\u56de\u5b57\u7b26\u4e32\uff01");
        }
        return null;
    }

    private JRDataSource createCustomDataSource(Report report, ParamsTable params, IUser user) throws Exception {
        JRDataSource dataSource = null;
        if (!StringUtil.isBlank((String)report.getScriptTemplate())) {
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
            runner.initBSFManager(null, params, user, new ArrayList());
            Object result = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), report.getScriptTemplate());
            if (result instanceof JRDataSource) {
                dataSource = (JRDataSource)result;
            } else {
                throw new Exception("Report[" + report.getName() + "]\u811a\u672c\u8fd0\u7b97\u7ed3\u679c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8fd4\u56de\u5b57\u7b26\u4e32\uff01");
            }
        }
        return dataSource;
    }

    public JasperReportBuilder build(Report report, ParamsTable params, IUser user) throws Exception {
        JasperReportBuilder builder = null;
        if ("SCRIPT".equals(report.getTemplateType()) && !StringUtil.isBlank((String)report.getScriptTemplate())) {
            FormDesignTimeService fs;
            Form searchForm;
            String searchFormId;
            JavaScriptFactory.clear();
            Document document = null;
            if (report.getDataSourceType().equals("DATASOURCE_TYPE_VIEW") && report.getIsPrint() == 0) {
                String viewId = report.getViewId();
                ViewDesignTimeService viewProcess = DesignTimeServiceManager.viewDesignTimeService();
                AbstractView view = viewProcess.doView(viewId);
                Form searchForm2 = view.getSearchForm();
                if (searchForm2 != null) {
                    document = searchForm2.createDocument(params, user);
                }
            } else if (report.getDataSourceType().equals("DATASOURCE_TYPE_SQL") && report.getIsPrint() == 0 && !StringUtils.isBlank((String)(searchFormId = report.getDataSourceSearchForm())) && (searchForm = (fs = DesignTimeServiceManager.formDesignTimeService()).doView(searchFormId)) != null) {
                document = searchForm.createDocument(params, user);
            }
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
            runner.initBSFManager(document, params, user, new ArrayList());
            Object result = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), report.getScriptTemplate());
            if (result instanceof JasperReportBuilder) {
                JRDataSource jrds;
                builder = (JasperReportBuilder)result;
                if ("DATASOURCE_TYPE_VIEW".equals(report.getDataSourceType())) {
                    if (!StringUtil.isBlank((String)report.getDataSourceView())) {
                        jrds = this.createViewDataSource(report, params, user);
                        builder.setDataSource(jrds);
                    }
                } else if ("DATASOURCE_TYPE_SQL".equals(report.getDataSourceType())) {
                    if (!StringUtil.isBlank((String)report.getDataSourceSqlScript())) {
                        String id = report.getDataSourceSqlConnectDs();
                        DataSourceDesignTimeService service = DesignTimeServiceManager.dataSourceDesignTimeService();
                        DataSource ds = (DataSource)service.findById(id);
                        Connection connection = ds.getConnection();
                        QueryBuilder query = this.createSqlDataSource(report, params, user);
                        builder.setDataSource(query, connection);
                    }
                } else if ("DATASOURCE_TYPE_CUSTOM".equals(report.getDataSourceType()) && !StringUtil.isBlank((String)report.getScriptTemplate())) {
                    jrds = this.createCustomDataSource(report, params, user);
                    builder.setDataSource(jrds);
                }
            } else {
                throw new Exception("Report[" + report.getName() + "]\u811a\u672c\u8fd0\u7b97\u7ed3\u679c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8fd4\u56de\u5b57\u7b26\u4e32\uff01");
            }
        }
        return builder;
    }

    public String exportPdf(Report report, ParamsTable params, IUser user) throws DRException, Exception {
        JasperPdfExporterBuilder exporterBuilder;
        Environment env = Environment.getInstance();
        String path = "/uploads/reports/" + report.getName() + ".pdf";
        String realPath = env.getRealPath(path);
        DataSource dataSource = this.getDataSource(report);
        ReportDesignTimeServiceImpl reportService = new ReportDesignTimeServiceImpl();
        DRDataSource subDrDataSource = null;
        if (!StringUtil.isBlank((String)report.getSubReportId())) {
            Report subReport = reportService.doView(report.getSubReportId());
            subDrDataSource = (DRDataSource)subReport.getDRDataSource();
        }
        if ("SCRIPT".equals(report.getTemplateType())) {
            exporterBuilder = DynamicReports.export.pdfExporter(realPath);
            this.build(report, params, user).export((AbstractJasperExporterBuilder)exporterBuilder);
        } else if ("JRXML".equals(report.getTemplateType())) {
            exporterBuilder = DynamicReports.export.pdfExporter(realPath);
            String jrxmlFilePath = report.getJrxmlFilePath();
            String isDefaultStyle = report.getIsDefaultStyle();
            DRDataSource drDataSource = (DRDataSource)report.getDRDataSource();
            List reportColumnInfos = report.getReportColumnInfos();
            if (jrxmlFilePath == null || isDefaultStyle == null) {
                return null;
            }
            String jrxmlFileRealPath = env.getRealPath(jrxmlFilePath);
            File jrxmlFile = new File(jrxmlFileRealPath);
            FileInputStream jrxmlInputStream = new FileInputStream(jrxmlFile);
            if (isDefaultStyle.equals("1")) {
                JasperReportBuilder jasperReport = DynamicReports.report();
                ((JasperReportBuilder)jasperReport.setTemplate(Templates.reportTemplate)).setTemplateDesign((InputStream)jrxmlInputStream).title(new ComponentBuilder[]{Templates.createTitleComponent(report.getName())});
                if (reportColumnInfos != null) {
                    jasperReport.columns(reportColumnInfos.toArray(new ColumnBuilder[reportColumnInfos.size()]));
                }
                if (drDataSource != null) {
                    jasperReport.setDataSource((JRDataSource)drDataSource);
                }
                jasperReport.export((AbstractJasperExporterBuilder)exporterBuilder);
            } else {
                JasperReportBuilder jasperReport = DynamicReports.report();
                ((JasperReportBuilder)jasperReport.setTemplateDesign((InputStream)jrxmlInputStream).setDataSource((JRDataSource)drDataSource).setParameter("REPORT_CONNECTION", (Object)dataSource.getConnection()).addParameter("REPORT_DATA", JRBeanCollectionDataSource.class)).setParameter("REPORT_DATA", (Object)(subDrDataSource == null ? null : new JRBeanCollectionDataSource(subDrDataSource.getValues(), false))).export((AbstractJasperExporterBuilder)exporterBuilder);
            }
        }
        return path;
    }

    public String exportHtml(Report report, ParamsTable params, IUser user) throws DRException, Exception {
        JasperHtmlExporterBuilder exporterBuilder;
        String path = "/uploads/reports/" + report.getId() + ".html";
        Environment env = Environment.getInstance();
        String realPath = env.getRealPath("/uploads/reports");
        File folder = new File(realPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        realPath = realPath + File.separator + report.getId() + ".html";
        DataSource dataSource = this.getDataSource(report);
        ReportDesignTimeServiceImpl reportService = new ReportDesignTimeServiceImpl();
        ArrayList<Report> subReports = new ArrayList<Report>();
        String subReportId = report.getSubReportId();
        if (!StringUtil.isBlank((String)subReportId)) {
            if (subReportId.indexOf(",") == -1) {
                Report subReport = reportService.doView(subReportId);
                subReports.add(subReport);
            } else {
                String[] subReportIds = subReportId.split(",");
                for (int i = 0; i < subReportIds.length; ++i) {
                    Report subReport = reportService.doView(subReportIds[i]);
                    subReports.add(subReport);
                }
            }
        }
        String htmlHeader = "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n<tr><td width=\"50%\" style=\"background:#eee;\">&nbsp;</td><td align=\"center\">\n";
        String htmlFooter = "<td width=\"50%\" style=\"background:#eee;\">&nbsp;</td></tr>";
        if ("SCRIPT".equals(report.getTemplateType())) {
            exporterBuilder = DynamicReports.export.htmlExporter(realPath);
            this.build(report, params, user).export((AbstractJasperExporterBuilder)exporterBuilder);
        } else if ("JRXML".equals(report.getTemplateType())) {
            exporterBuilder = DynamicReports.export.htmlExporter(realPath).setHtmlHeader(htmlHeader).setHtmlFooter(htmlFooter);
            String jrxmlFilePath = report.getJrxmlFilePath();
            String isDefaultStyle = report.getIsDefaultStyle();
            DRDataSource drDataSource = (DRDataSource)report.getDRDataSource();
            List reportColumnInfos = report.getReportColumnInfos();
            if (jrxmlFilePath == null || isDefaultStyle == null) {
                return null;
            }
            String jrxmlFileRealPath = env.getRealPath(jrxmlFilePath);
            File jrxmlFile = new File(jrxmlFileRealPath);
            FileInputStream jrxmlInputStream = new FileInputStream(jrxmlFile);
            if (isDefaultStyle.equals("1")) {
                JasperReportBuilder jasperReport = DynamicReports.report();
                ((JasperReportBuilder)jasperReport.setTemplate(Templates.reportTemplate)).setTemplateDesign((InputStream)jrxmlInputStream).title(new ComponentBuilder[]{Templates.createTitleComponent(report.getName())});
                if (reportColumnInfos != null) {
                    jasperReport.columns(reportColumnInfos.toArray(new ColumnBuilder[reportColumnInfos.size()]));
                }
                if (drDataSource != null) {
                    jasperReport.setDataSource((JRDataSource)drDataSource);
                }
                jasperReport.export((AbstractJasperExporterBuilder)exporterBuilder);
            } else {
                JasperReportBuilder jasperReport = DynamicReports.report();
                jasperReport.setTemplateDesign((InputStream)jrxmlInputStream).setDataSource((JRDataSource)drDataSource).setParameter("REPORT_CONNECTION", (Object)dataSource.getConnection());
                if (!subReports.isEmpty()) {
                    for (Report rt : subReports) {
                        DRDataSource subDrDataSource = (DRDataSource)rt.getDRDataSource();
                        ((JasperReportBuilder)jasperReport.addParameter("REPORT_DATA" + rt.getId(), JRBeanCollectionDataSource.class)).setParameter("REPORT_DATA" + rt.getId(), (Object)(subDrDataSource == null ? null : new JRBeanCollectionDataSource(subDrDataSource.getValues(), false)));
                    }
                }
                jasperReport.export((AbstractJasperExporterBuilder)exporterBuilder);
            }
        }
        return path;
    }

    public String exportExcel(Report report, ParamsTable params, IUser user) throws DRException, Exception {
        JasperXlsExporterBuilder exporterBuilder;
        Environment env = Environment.getInstance();
        String path = "/uploads/reports/" + report.getName() + ".xls";
        String realPath = env.getRealPath(path);
        DataSource dataSource = this.getDataSource(report);
        ReportDesignTimeServiceImpl reportService = new ReportDesignTimeServiceImpl();
        DRDataSource subDrDataSource = null;
        if (!StringUtil.isBlank((String)report.getSubReportId())) {
            Report subReport = reportService.doView(report.getSubReportId());
            subDrDataSource = (DRDataSource)subReport.getDRDataSource();
        }
        if ("SCRIPT".equals(report.getTemplateType())) {
            exporterBuilder = (JasperXlsExporterBuilder)((JasperXlsExporterBuilder)((JasperXlsExporterBuilder)DynamicReports.export.xlsExporter(realPath).setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true))).setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true))).setWhitePageBackground(Boolean.valueOf(false));
            this.build(report, params, user).export((AbstractJasperExporterBuilder)exporterBuilder);
        } else if ("JRXML".equals(report.getTemplateType())) {
            exporterBuilder = (JasperXlsExporterBuilder)((JasperXlsExporterBuilder)((JasperXlsExporterBuilder)DynamicReports.export.xlsExporter(realPath).setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true))).setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true))).setWhitePageBackground(Boolean.valueOf(false));
            String jrxmlFilePath = report.getJrxmlFilePath();
            String isDefaultStyle = report.getIsDefaultStyle();
            DRDataSource drDataSource = (DRDataSource)report.getDRDataSource();
            List reportColumnInfos = report.getReportColumnInfos();
            if (jrxmlFilePath == null || isDefaultStyle == null) {
                return null;
            }
            String jrxmlFileRealPath = env.getRealPath(jrxmlFilePath);
            File jrxmlFile = new File(jrxmlFileRealPath);
            FileInputStream jrxmlInputStream = new FileInputStream(jrxmlFile);
            if (isDefaultStyle.equals("1")) {
                JasperReportBuilder jasperReport = DynamicReports.report();
                ((JasperReportBuilder)jasperReport.setTemplate(Templates.reportTemplate)).setTemplateDesign((InputStream)jrxmlInputStream).title(new ComponentBuilder[]{Templates.createTitleComponent(report.getName())});
                if (reportColumnInfos != null) {
                    jasperReport.columns(reportColumnInfos.toArray(new ColumnBuilder[reportColumnInfos.size()]));
                }
                if (drDataSource != null) {
                    jasperReport.setDataSource((JRDataSource)drDataSource);
                }
                jasperReport.export((AbstractJasperExporterBuilder)exporterBuilder);
            } else {
                JasperReportBuilder jasperReport = DynamicReports.report();
                ((JasperReportBuilder)jasperReport.setTemplateDesign((InputStream)jrxmlInputStream).setDataSource((JRDataSource)drDataSource).setParameter("REPORT_CONNECTION", (Object)dataSource.getConnection()).addParameter("REPORT_DATA", JRBeanCollectionDataSource.class)).setParameter("REPORT_DATA", (Object)(subDrDataSource == null ? null : new JRBeanCollectionDataSource(subDrDataSource.getValues(), false))).export((AbstractJasperExporterBuilder)exporterBuilder);
            }
        }
        return path;
    }

    private DataSource getDataSource(Report report) throws Exception {
        String applicationId = report.getApplicationid();
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        Application application = (Application)appService.findById(applicationId);
        DataSourceDesignTimeService dataSourceService = DesignTimeServiceManager.dataSourceDesignTimeService();
        DataSource dataSource = report.getDataSourceType().equals("DATASOURCE_TYPE_VIEW") || report.getIsPrint() == 1 ? (DataSource)dataSourceService.findById(application.getDatasourceId()) : dataSourceService.getDataSourceByName(report.getDataSourceName(), applicationId);
        return dataSource;
    }
}

