/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.listener;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.Environment;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeIndexCacheManager;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.init.InitSystem;
import cn.myapps.runtime.common.dao.WrapConnection;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormTableProcessBean;
import cn.myapps.runtime.dynaform.form.service.FormRunTimeServiceImpl;
import cn.myapps.runtime.macro.runner.JavaScriptRunner;
import cn.myapps.runtime.scheduler.engine.RegularScheduler;
import cn.myapps.scheduler.SchedulerUtil;
import cn.myapps.util.RuntimeDaoManager;
import com.bcxin.saas.core.exceptions.SaasBadException;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.util.StopWatch;

public class ApplicationContextEventListener
implements ApplicationListener<ApplicationContextEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            logger.info("\u521d\u59cb\u5316\u5f00\u59cb");
            long start = System.currentTimeMillis();
            try {
                Environment evt = Environment.getInstance();
                String workRootPath = evt.getWorkspaceRootPath();
                File newPath = new File(workRootPath);
                if (!newPath.exists()) {
                    logger.error(workRootPath + "\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
                }
                String res = PropertyUtil.getPath();
                evt.setApplicationRealPath(res);
                DesignTimeIndexCacheManager.getInstance().init(1);
                File file = new File(PropertyUtil.getPath() + File.separator + "initTable.log");
                boolean isExist = file.exists();
                InitSystem.init((boolean)isExist);
                String indexIdPath = workRootPath + File.separator + "url.index";
                File index = new File(indexIdPath);
                if (index.exists()) {
                    ApplicationDesignTimeService applicationService = DesignTimeServiceManager.applicationDesignTimeService();
                    List apps = applicationService.list("", "");
                    ExecutorService executor = Executors.newFixedThreadPool(5);
                    StopWatch stopWatch = new StopWatch();
                    try {
                        stopWatch.start();
                        List<CompletableFuture> futureList = apps.stream().map(request -> CompletableFuture.runAsync(() -> {
                            try {
                                ApplicationContextEventListener.executeAppWarmUp(request, isExist);
                            }
                            catch (Exception e) {
                                throw new SaasBadException(e);
                            }
                        }, executor)).collect(Collectors.toList());
                        CompletableFuture<Void> allCF = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
                        Void result = allCF.join();
                        stopWatch.stop();
                        logger.error("APP\u9884\u70ed\u6267\u884c\u5b8c\u6bd5:{}; \u603b\u5171\u8017\u65f6:{} \u79d2", (Object)result, (Object)stopWatch.getTotalTimeSeconds());
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                Thread.sleep(1000L);
                if (!isExist) {
                    file.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    DesignTimeSerializableCache.flush2SecondCached();
                    PersistenceUtils.closeSessionAndConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            logger.info("\u521d\u59cb\u5316\u7ed3\u675f\uff0c\u7528\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms.");
        } else if (event instanceof ContextClosedEvent || event instanceof ContextStoppedEvent) {
            logger.info("\u5f00\u59cb\u5378\u8f7d\u8d44\u6e90");
            try {
                SchedulerUtil.destroy();
                RegularScheduler.shutdown();
                EhcacheProvider cacheProvider = (EhcacheProvider)MyCacheManager.getProviderInstance();
                cacheProvider.destory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void executeAppWarmUp(Application application, boolean isExist) throws Exception {
        if (application.getDataSourceDefine() == null) {
            return;
        }
        JavaScriptRunner.preCompile((Application)application);
        Boolean isRight = true;
        if (isRight.booleanValue() && !isExist) {
            DataSource dataSource = application.getDataSourceDefine();
            RuntimeDaoManager.getApplicationInitDAO((WrapConnection)new WrapConnection(dataSource.getSqlDataSource(), dataSource.getConnection(), null, application.getApplicationid()), (String)application.getDataSourceDefine().getDbTypeName()).initTables();
            FormRunTimeServiceImpl formRunTimeService = new FormRunTimeServiceImpl();
            List forms = formRunTimeService.getFormsByApplication(application.getId());
            FormTableProcessBean tableProcess = new FormTableProcessBean(application.getId());
            for (Form form : forms) {
                try {
                    tableProcess.createOrUpdateDynaTable(form, null);
                    logger.info("\u540c\u6b65" + form.getName() + "\u8868\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u540c\u6b65" + form.getName() + "\u8868\u65f6\u62a5\u9519" + e.getMessage());
                }
            }
        }
        try {
            if (!application.isActivated() || !isRight.booleanValue()) {
                logger.error("\u672a\u542f\u7528:{}\u5b9a\u65f6\u4efb\u52a1", (Object)application.getUrl());
            }
        }
        catch (Exception ex) {
            ex.getStackTrace();
        }
    }
}

