/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.contacts.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.data.tree.ApplicationNode;
import cn.myapps.common.data.tree.DepartmentNode;
import cn.myapps.common.data.tree.Node;
import cn.myapps.common.data.tree.RoleNode;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.contacts.controller.BaseController;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="ContactsAction")
@RequestMapping(value={"/api/contacts"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ContactsController
extends BaseController {
    @Autowired
    protected HttpServletRequest request;

    @RequestMapping(value={"/contacts/getAllUser.action", "/getAllUser.action"})
    public Map<String, Object> getAllUser() {
        ArrayList<UserNode> users = new ArrayList<UserNode>();
        WebUser webUser = this.getUser();
        try {
            UserProcess userPorcess = AuthTimeServiceManager.userRuntimeService();
            String _pageNo = this.params.getParameterAsString("pageNo");
            int pageNo = StringUtil.isBlank((String)_pageNo) ? 1 : Integer.valueOf(_pageNo);
            int pageCount = 10;
            this.datas = userPorcess.doQueryByDomainAndOrderByNameLetter(webUser.getDomainid(), "nameLetter", pageNo, pageCount);
            Collection user = this.datas.getDatas();
            for (UserVO userVO : user) {
                UserNode u = this.getUser(userVO);
                users.add(u);
            }
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            result.put("datas", users);
            result.put("linesPerPage", Integer.valueOf(this.datas.getLinesPerPage()));
            result.put("pageCount", Integer.valueOf(this.datas.getPageCount()));
            result.put("pageNo", Integer.valueOf(this.datas.getPageNo()));
            result.put("rowCount", Integer.valueOf(this.datas.getRowCount()));
            return this.addActionResult(true, "", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getContacts.action"})
    public Map<String, Object> getContacts() {
        ArrayList<DepartmentNode> avatars = new ArrayList<DepartmentNode>();
        WebUser webUser = this.getUser();
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            UserProcess userPorcess = AuthTimeServiceManager.userRuntimeService();
            HashMap<String, ArrayList<DepartmentNode>> deptMap = new HashMap<String, ArrayList<DepartmentNode>>();
            List departments = (List)process.doQueryByDomainOrderLevelDescOrderByNo(webUser.getDomainid());
            Collection users = userPorcess.queryByDomain(webUser.getDomainid());
            for (DepartmentVO departmentVO : departments) {
                DepartmentNode d = new DepartmentNode();
                d.setId(departmentVO.getId());
                d.setName(departmentVO.getName());
                DepartmentVO s = departmentVO.getSuperior();
                for (UserVO userVO : users) {
                    if (userVO.getStatus() != 1 || !"public".equals(userVO.getPermissionType()) || !userVO.getDefaultDepartment().equals(departmentVO.getId())) continue;
                    UserNode u = new UserNode();
                    u.setId(userVO.getId());
                    u.setName(userVO.getName());
                    if (userVO.isTelephonePublic()) {
                        u.setMobile(userVO.getTelephone());
                    }
                    if (userVO.isTelephonePublic2()) {
                        u.setMobile2(userVO.getTelephone2());
                    }
                    if (userVO.isEmailPublic()) {
                        u.setEmail(userVO.getEmail());
                    }
                    if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                        String avatar = userVO.getAvatarUri();
                        u.setAvatar(avatar);
                    } else {
                        u.setAvatar("");
                    }
                    u.setDept(d.getName());
                    d.addChildren((Node)u);
                }
                if (deptMap.get(d.getId()) != null) {
                    d.addChildrens((List)deptMap.get(d.getId()));
                }
                if (s != null) {
                    ArrayList<DepartmentNode> list = (ArrayList<DepartmentNode>)deptMap.get(s.getId());
                    if (list == null) {
                        list = new ArrayList<DepartmentNode>();
                        deptMap.put(s.getId(), list);
                    }
                    list.add(d);
                    continue;
                }
                avatars.add(d);
            }
            return this.addActionResult(true, "", avatars);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getApplicationAndRoleContactsTree.action", "/getApplicationAndRoleContactsTree.action"})
    public Map<String, Object> getApplicationAndRoleContactsTree() {
        ArrayList<Object> avatars = new ArrayList<Object>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        try {
            String applictaionId = params.getParameterAsString("applictaionId");
            String roleId = params.getParameterAsString("roleId");
            if (StringUtil.isBlank((String)roleId) && StringUtil.isBlank((String)applictaionId)) {
                Collection apps = webUser.getDomain().getApplications();
                for (Application appVO : apps) {
                    if (!appVO.isActivated()) continue;
                    ApplicationNode app = new ApplicationNode();
                    app.setId(appVO.getId());
                    app.setName(appVO.getName());
                    avatars.add(app);
                }
            } else if (!StringUtil.isBlank((String)applictaionId) && StringUtil.isBlank((String)roleId)) {
                RoleDesignTimeService roleService = AuthTimeServiceManager.roleRuntimeService();
                Collection roles = roleService.getRolesByApplication(applictaionId);
                for (Role roleVO : roles) {
                    if (roleVO.getStatus() != 1) continue;
                    RoleNode role = new RoleNode();
                    role.setId(roleVO.getId());
                    role.setName(roleVO.getName());
                    avatars.add(role);
                }
            } else if (!StringUtil.isBlank((String)roleId)) {
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                Collection users = userProcess.queryByRoleAndDomain(roleId, webUser.getDomainid());
                for (UserVO userVO : users) {
                    if (userVO.getStatus() == 0) continue;
                    UserNode u = this.getUser(userVO);
                    avatars.add(u);
                }
            }
            return this.addActionResult(true, "", avatars);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getContactsBySearch.action"})
    public Map<String, Object> getContactsBySearch() {
        ArrayList<UserNode> users = new ArrayList<UserNode>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        String keyWord = params.getParameterAsString("keyWord");
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection user = userProcess.queryByFuzzy(keyWord, webUser.getDomainid());
            for (UserVO userVO : user) {
                if (userVO.getStatus() != 1 || !"public".equals(userVO.getPermissionType())) continue;
                UserNode u = this.getUser(userVO);
                users.add(u);
            }
            return this.addActionResult(true, "", users);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getContactsByFirstLetter.action"})
    public Map<String, Object> getContactsByFirstLetter() {
        ArrayList<UserNode> users = new ArrayList<UserNode>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        String keyWord = params.getParameterAsString("keyWord");
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection user = userProcess.queryByFirstLetter(keyWord, webUser.getDomainid());
            for (UserVO userVO : user) {
                UserNode u = this.getUser(userVO);
                users.add(u);
            }
            return this.addActionResult(true, "", users);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getContactsTree.action", "/getContactsTree.action"})
    public Map<String, Object> getContactsTree() {
        ArrayList<Object> avatars = new ArrayList<Object>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        try {
            String parentId = params.getParameterAsString("parentId");
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (StringUtil.isBlank((String)parentId)) {
                DepartmentVO departmentVO = process.getRootDepartmentByDomainId(webUser.getDomainid());
                DepartmentNode d = new DepartmentNode();
                d.setId(departmentVO.getId());
                d.setName(departmentVO.getName());
                avatars.add(d);
            } else {
                DepartmentVO parent = (DepartmentVO)process.doView(parentId);
                Collection departments = process.getDatasByParent(parentId);
                Collection users = userProcess.queryByDepartment(parentId, true);
                for (UserVO userVO : users) {
                    if (userVO.getStatus() == 0 || userVO.getPermissionType().equals("private")) continue;
                    UserNode u = new UserNode();
                    u.setId(userVO.getId());
                    u.setName(userVO.getName());
                    if (userVO.isTelephonePublic()) {
                        u.setMobile(userVO.getTelephone());
                    }
                    if (userVO.isTelephonePublic2()) {
                        u.setMobile2(userVO.getTelephone2());
                    }
                    if (userVO.isEmailPublic()) {
                        u.setEmail(userVO.getEmail());
                    }
                    if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                        String avatar = userVO.getAvatarUri();
                        u.setAvatar(avatar);
                    } else {
                        u.setAvatar("");
                    }
                    u.setDept(parent.getName());
                    avatars.add(u);
                }
                for (DepartmentVO departmentVO : departments) {
                    DepartmentNode d = new DepartmentNode();
                    d.setId(departmentVO.getId());
                    d.setName(departmentVO.getName());
                    avatars.add(d);
                }
            }
            return this.addActionResult(true, "", avatars);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/addFavoriteContact.action"})
    public Map<String, Object> addFavoriteContact() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            UserVO userVO = (UserVO)userProcess.doView(user.getId());
            if (StringUtil.isBlank((String)userVO.getFavoriteContacts())) {
                userVO.setFavoriteContacts(userId);
            } else {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts() + ";" + userId);
            }
            userProcess.doUpdate((AuthtimeValueObject)userVO);
            return this.addActionResult(true, "\u6dfb\u52a0\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/removeFavoriteContact.action"})
    public Map<String, Object> removeFavoriteContact() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            UserVO userVO = (UserVO)userProcess.doView(user.getId());
            if (userVO.getFavoriteContacts().indexOf(userId) == 0) {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts().replace(userId, ""));
            } else {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts().replace(";" + userId, ""));
            }
            userProcess.doUpdate((AuthtimeValueObject)userVO);
            return this.addActionResult(true, "\u79fb\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getFavoriteContacts.action", "/getFavoriteContacts.action"})
    public Map<String, Object> getFavoriteContacts() {
        try {
            ArrayList<UserNode> list = new ArrayList<UserNode>();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            UserVO vo = (UserVO)userProcess.doView(user.getId());
            if (!StringUtil.isBlank((String)vo.getFavoriteContacts())) {
                String[] ids = vo.getFavoriteContacts().split(";");
                StringBuilder cdt = new StringBuilder();
                for (int i = 0; i < ids.length; ++i) {
                    cdt.append("'").append(ids[i]).append("'").append(",");
                }
                cdt.setLength(cdt.length() - 1);
                Collection users = userProcess.queryByUserIds(ids, user.getDomainid());
                for (UserVO userVO : users) {
                    if (userVO.getStatus() != 1 || !"public".equals(userVO.getPermissionType())) continue;
                    UserNode u = this.getUser(userVO);
                    list.add(u);
                }
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/isFavoriteContact.action"})
    public Map<String, Object> isFavoriteContact() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            UserVO userVO = (UserVO)userProcess.doView(user.getId());
            if (userVO.getFavoriteContacts() != null && userVO.getFavoriteContacts().indexOf(userId) >= 0) {
                return this.addActionResult(true, "", true);
            }
            return this.addActionResult(true, "", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getAvatar.action"})
    public Map<String, Object> getAvatar() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("id");
            UserVO userVO = (UserVO)userProcess.doView(userId);
            if (userVO != null) {
                String avatar = "";
                if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                    avatar = userVO.getAvatarUri();
                }
                return this.addActionResult(true, "", avatar);
            }
            return this.addActionResult(false, "\u627e\u4e0d\u5230\u6307\u5b9a\u7528\u6237", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/contacts/getRoleOrDeptUserCounts.action"})
    public Map<String, Object> getRoleOrDeptUserCounts() {
        try {
            ParamsTable params = this.getParams();
            Integer type = params.getParameterAsInteger("type");
            String id = params.getParameterAsString("id");
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Long userCounts = null;
            userCounts = userProcess.getCountsByDepartment(id);
            if (type == 2) {
                userCounts = userProcess.getCountsByDepartment(id);
            } else if (type == 4) {
                userCounts = userProcess.getCountsByRoleAndDomain(id, this.getUser().getDomainid());
            }
            return this.addActionResult(true, "", userCounts);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getHisActors4FreeFlow.action"})
    public Map<String, Object> getHisActors4FreeFlow() {
        try {
            ParamsTable params = this.getParams();
            WebUser webUser = this.getUser();
            String _userId = webUser.getId();
            String stateId = params.getParameterAsString("stateId");
            String applicationId = params.getParameterAsString("applicationId");
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            FlowHistoryServiceImpl hisProcess = new FlowHistoryServiceImpl(applicationId);
            Collection list = hisProcess.getFlowHistorysByDocId(stateId);
            HashMap<String, UserVO> userMap = new HashMap<String, UserVO>();
            for (FlowHistoryVO his : list) {
                String userId = his.getAuditorId();
                if (_userId.equals(userId) || userMap.containsKey(userId)) continue;
                UserVO userVO = (UserVO)userProcess.doView(userId);
                userMap.put(userId, userVO);
            }
            ArrayList<UserNode> userList = new ArrayList<UserNode>();
            for (String key : userMap.keySet()) {
                userList.add(this.getUser((UserVO)userMap.get(key)));
            }
            return this.addActionResult(true, "", userList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25", "");
        }
    }

    private UserNode getUser(UserVO userVO) throws Exception {
        DepartmentProcess deptProcess;
        DepartmentVO dept;
        UserNode u = new UserNode();
        u.setId(userVO.getId());
        u.setName(userVO.getName());
        if (userVO.isTelephonePublic()) {
            u.setMobile(userVO.getTelephone());
        }
        if (userVO.isTelephonePublic2()) {
            u.setMobile2(userVO.getTelephone2());
        }
        if (userVO.isEmailPublic()) {
            u.setEmail(userVO.getEmail());
        }
        if ((dept = (DepartmentVO)(deptProcess = AuthTimeServiceManager.departmentRuntimeService()).doView(userVO.getDefaultDepartment())) != null) {
            u.setDept(dept.getName());
        } else {
            u.setDept("");
        }
        if (!StringUtil.isBlank((String)userVO.getAvatar())) {
            String avatar = userVO.getAvatarUri();
            u.setAvatar(avatar);
        } else {
            u.setAvatar("");
        }
        return u;
    }
}

