/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import com.alibaba.druid.pool.DruidDataSource;
import com.bcxin.saas.core.logs.Logging;
import com.bcxin.saas.core.logs.SysLogProvider;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
public class DataSourceConfig
implements TransactionManagementConfigurer {
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.initialSize}")
    private int initialSize;
    @Value(value="${spring.datasource.maxActive}")
    private int maxActive;
    @Value(value="${spring.datasource.maxWait}")
    private int maxWait;
    @Value(value="${spring.datasource.validationQuery}")
    private String validationQuery;
    @Value(value="${spring.datasource.testWhileIdle}")
    private boolean testWhileIdle;
    @Value(value="${spring.datasource.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${spring.datasource.testOnReturn}")
    private boolean testOnReturn;

    @Logging
    @Bean(value={"druidDataSource", "loggerDataSource"})
    public DataSource druidDataSource() {
        if (this.maxWait < 100) {
            this.maxWait = 3600;
        }
        DataSource dataSource = null;
        try {
            dataSource = PersistenceUtils.getDruidDataSource((String)"CORE", (String)this.username, (String)this.password, (String)this.driverClassName, (String)this.dbUrl, (String)String.valueOf(this.maxActive), (String)String.valueOf(this.maxWait));
            SysLogProvider.setDataSource((DataSource)dataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSource;
    }

    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource) {
        return new JdbcTemplate(kmDataSource);
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.druidDataSource());
    }

    @PreDestroy
    public void preDestroy() throws InterruptedException {
        DataSource dataSource = this.druidDataSource();
        if (dataSource != null && dataSource instanceof DruidDataSource) {
            DruidDataSource dds = (DruidDataSource)dataSource;
            dds.clearFilters();
            dds.unregisterMbean();
            dds.close();
        }
    }
}

