/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import com.auth0.jwt.exceptions.JWTDecodeException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class CommonsExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(CommonsExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        block23: {
            String url = httpServletRequest.getRequestURI();
            try {
                PersistenceUtils.closeSessionAndConnection();
                boolean unAuthorized = e instanceof JWTDecodeException;
                if (!unAuthorized) {
                    try {
                        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
                            ContentCachingRequestWrapper rqw = (ContentCachingRequestWrapper)httpServletRequest;
                            String body = new String(rqw.getContentAsByteArray(), StandardCharsets.UTF_8);
                            StringBuilder sbHeader = new StringBuilder();
                            Enumeration pNames = rqw.getParameterNames();
                            if (pNames != null) {
                                while (pNames.hasMoreElements()) {
                                    String pName = (String)pNames.nextElement();
                                    sbHeader.append(String.format("%s=%s", pName, rqw.getParameter(pName)));
                                }
                            }
                            log.error("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38:{}", (Object)String.format("param=%s;body=%s", sbHeader, body), (Object)e);
                        } else {
                            log.error("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38:{}", (Object)url, (Object)e);
                        }
                    }
                    catch (Exception ex) {
                        log.error("resolveException\u8bb0\u5f55\u53c2\u6570\u5f02\u5e38:{}={}", new Object[]{url, ex.toString(), e});
                    }
                }
                if (httpServletResponse.isCommitted()) break block23;
                httpServletResponse.setContentType("text/json;charset=utf-8");
                httpServletResponse.resetBuffer();
                try (PrintWriter writer = httpServletResponse.getWriter();){
                    JSONObject json = new JSONObject();
                    String message = "\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                    if (unAuthorized) {
                        httpServletResponse.setStatus(401);
                        message = "\u672a\u6388\u6743\u64cd\u4f5c";
                    } else {
                        httpServletResponse.setStatus(500);
                    }
                    json.put((Object)"errcode", (Object)httpServletResponse.getStatus());
                    json.put((Object)"errmsg", (Object)message);
                    json.put((Object)"detail", (Object)e.toString());
                    writer.print(json);
                }
                httpServletResponse.flushBuffer();
            }
            catch (Exception ex) {
                log.error("\u6267\u884c\u53d1\u751f\u5f02\u5e38:{}-{}", new Object[]{url, ex, e});
            }
        }
        return null;
    }
}

