/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.base.web.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class GetRequestEncodingFilter
extends OncePerRequestFilter {
    private String encoding;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        request.setCharacterEncoding(this.encoding);
        response.setCharacterEncoding(this.encoding);
        GetHttpServletRequestWrapper req = new GetHttpServletRequestWrapper(request, this.encoding);
        chain.doFilter((ServletRequest)req, (ServletResponse)response);
    }

    class GetHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private String charset;

        public GetHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            this.charset = "UTF-8";
        }

        public GetHttpServletRequestWrapper(HttpServletRequest request, String charset) {
            super(request);
            this.charset = "UTF-8";
            this.charset = charset;
        }

        public String getParameter(String name) {
            String value = super.getParameter(name);
            try {
                if (value != null) {
                    value = new String(value.getBytes("ISO-8859-1"), this.charset);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return value;
        }

        public String[] getParameterValues(String name) {
            String[] values = super.getParameterValues(name);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        values[i] = new String(values[i].getBytes("ISO-8859-1"), this.charset);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            return values;
        }
    }
}

