package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
@ComponentScan(basePackages = {"cn.myapps.run","cn.myapps.common.util","cn.myapps.conf",
		"cn.myapps.email.controller","com.teemlink.email.*","cn.myapps.*",
		"cn.myapps.email.**.service"
})
@EnableFeignClients(basePackages = "cn.myapps.conf")
@EntityScan(basePackages= {"cn.myapps.auth.model","com.teemlink.email"})
@EnableJpaRepositories(basePackages= {"cn.myapps.auth.dao","com.teemlink.email.**.dao"})
public class EmailWithWar extends SpringBootServletInitializer {

	public static void main(String[] args) {
		try{
			SpringApplication.run(EmailWithWar.class, args);
		}catch (Exception e){
			e.printStackTrace();
		}

	}

	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
		return builder.sources(EmailWithWar.class);
	}

}
