/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.listener;

import cn.myapps.common.model.application.Application;
import cn.myapps.components.RingBufferProducer;
import cn.myapps.components.events.DistributeDesignCacheObject;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.events.FsDesignTimeComponentChangedEvent;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import com.bcxin.saas.core.components.JsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class FsDesignTimeComponentChangedEventListener
implements ApplicationListener<FsDesignTimeComponentChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FsDesignTimeComponentChangedEvent.class);
    private final DiscoveryClient discoveryClient;
    private final JsonProvider jsonProvider;
    private final RingBufferProducer ringBufferProducer;

    public FsDesignTimeComponentChangedEventListener(DiscoveryClient discoveryClient, JsonProvider jsonProvider, RingBufferProducer ringBufferProducer) {
        this.discoveryClient = discoveryClient;
        this.jsonProvider = jsonProvider;
        this.ringBufferProducer = ringBufferProducer;
    }

    public void onApplicationEvent(FsDesignTimeComponentChangedEvent event) {
        logger.error("\u5373\u5c06\u66f4\u65b0\u5982\u4e0b\u4fe1\u606f={}\u5230runtime", (Object)event);
        String appId = event.getDesignObject().getApplicationid();
        ArrayList<String> parentIds = new ArrayList<String>();
        if (event.getDesignObject() instanceof Application) {
            appId = event.getDesignObject().getId();
        }
        parentIds.add(event.getDesignObject().getParentId());
        Collection itemRequests = event.getAll().stream().map(ii -> RefreshDesignRequest.ComponentDataItemRequest.create((RefreshDesignRequest.ActionType)RefreshDesignRequest.ActionType.Changed, (String)ii.getId())).collect(Collectors.toList());
        RefreshDesignRequest rq = RefreshDesignRequest.create(parentIds, (Collection)itemRequests);
        DesignTimeSerializableCache.doRefreshWrapperObject((String)appId, (RefreshDesignRequest)rq);
        DistributeDesignCacheObject data = DistributeDesignCacheObject.create(appId, rq);
        this.ringBufferProducer.publish(data);
    }
}

