/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.widget.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.summary.service.SummaryCfgDesignTimeService;
import cn.myapps.designtime.widget.service.PageWidgetDesignTimeService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u5c0f\u5de5\u5177\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class PageWidgetController
extends AbstractDesignTimeController {
    private PageWidgetDesignTimeService pageWidgetDesignTimeService = DesignTimeServiceManager.pageWidgetDesignTimeService();

    @GetMapping(path={"/{applicationId}/widgets"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u5de5\u5177\u5217\u8868", notes="\u83b7\u53d6\u5c0f\u5de5\u5177\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u5b57", required=true, paramType="query", dataType="string")})
    public Resource getWidgetsList(@PathVariable String applicationId, String name) {
        ParamsTable params = this.getParams();
        String pageNo = params.getParameterAsString("pageNo");
        String linesPerPage = params.getParameterAsString("linesPerPage");
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.pageWidgetDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/widgets/{widgetId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u5de5\u5177\u8be6\u60c5", notes="\u83b7\u53d6\u5c0f\u5de5\u5177\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="widgetId", value="\u5c0f\u5de5\u5177id", required=true, paramType="path", dataType="string")})
    public Resource doGetWidget(@PathVariable String widgetId) {
        try {
            SummaryCfgDesignTimeService summaryProcess;
            SummaryCfgVO summary;
            PageWidget pageWidget = (PageWidget)this.pageWidgetDesignTimeService.findById(widgetId);
            String summaryName = "";
            if (pageWidget != null && "summary".equals(pageWidget.getType()) && (summary = (SummaryCfgVO)(summaryProcess = DesignTimeServiceManager.summaryCfgDesignTimeService()).findById(pageWidget.getActionContent())) != null) {
                summaryName = summary.getTitle();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", pageWidget);
            map.put("summaryName", summaryName);
            return this.success("ok", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/widgets"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u5c0f\u5de5\u5177", notes="\u65b0\u5efa\u5c0f\u5de5\u5177")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateWidgets(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            PageWidget pageWidget = (PageWidget)this.json2obj(json, PageWidget.class);
            pageWidget.setApplicationid(applicationId);
            pageWidget.setParentId(applicationId);
            if (StringUtil.isBlank((String)pageWidget.getId())) {
                pageWidget.setId(Sequence.getDesignTimeSequence());
            }
            if (pageWidget.getName().equals("")) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            String regEx = "[ \\~\\!\\/\\@\\#\\$\\%\\^\\&\\*\\(\\)\\-\\=\\+\\\\\\|\\[\\{\\}\\]\\;\\:\\'\\\"\\,\\<\\.\\>\\/\\?]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(pageWidget.getName());
            if (m.find()) {
                throw new OBPMValidateException("{*[Name]*}{*[can.not.exist.invalidchar]*}");
            }
            this.doSaveValidate(pageWidget);
            this.pageWidgetDesignTimeService.save((Object)pageWidget);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)pageWidget.getId());
            return this.success("ok", jsonObject);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/widgets"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u5c0f\u5de5\u5177", notes="\u66f4\u65b0\u5c0f\u5de5\u5177")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateWidgets(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            PageWidget oldpageWidget = (PageWidget)this.pageWidgetDesignTimeService.findById(json.getString("id"));
            PageWidget pageWidget = (PageWidget)this.json2obj(json, PageWidget.class);
            pageWidget.setApplicationid(oldpageWidget.getApplicationid());
            this.doSaveValidate(pageWidget);
            this.pageWidgetDesignTimeService.saveOrUpdate((Object)pageWidget);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/widgets"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u5c0f\u5de5\u5177", notes="\u5220\u9664\u5c0f\u5de5\u5177\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteWidgets(@RequestBody String[] ids) {
        try {
            this.pageWidgetDesignTimeService.delete(ids);
            for (String id : ids) {
                DesignTimeSerializableCache.remove((String)id);
            }
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(PageWidget widget) throws Exception {
        List list = this.pageWidgetDesignTimeService.list(widget.getApplicationid(), widget.getName());
        for (PageWidget pageWidget : list) {
            if (widget.getId().equals(pageWidget.getId()) && widget.getName().equals(pageWidget.getName())) break;
            if (!pageWidget.getName().equals(widget.getName())) continue;
            throw new OBPMValidateException(" \u8be5\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u547d\u540d\u518d\u4fdd\u5b58\uff01 ");
        }
    }
}

