/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.upload.servlet;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.upload.ejb.UploadInfo;
import cn.myapps.runtime.dynaform.upload.ejb.UploadProcess;
import cn.myapps.runtime.dynaform.upload.ejb.UploadVO;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -3986799601741140351L;
    private static final Logger Log = LoggerFactory.getLogger(UploadServlet.class);
    private String[] excludeTypes = new String[0];
    private static final StringBuffer excludeTypesString = new StringBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExcludeTypes(String[] excludeTypes) {
        Class<UploadServlet> clazz = UploadServlet.class;
        synchronized (UploadServlet.class) {
            this.excludeTypes = excludeTypes;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private String[] getExcludeTypes() {
        return Arrays.copyOf(this.excludeTypes, this.excludeTypes.length);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String excludeTypes = config.getInitParameter("excludeType");
        excludeTypesString.append(excludeTypes);
        if (!StringUtil.isBlank((String)excludeTypes)) {
            this.setExcludeTypes(excludeTypes.split("\\|"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = "";
        String fileSaveMode = "";
        String allowedTypes = "";
        String applicationId = "";
        String uploadContentType = "";
        String uploadFileName = "";
        String uuid = "";
        UploadInfo uploadInfo = null;
        try {
            String data = request.getParameter("data");
            String[] dataArray = data.split(",");
            path = dataArray[0].split(":")[1].equals("null") ? "" : dataArray[0].split(":")[1];
            fileSaveMode = dataArray[1].split(":")[1].equals("null") ? "" : dataArray[1].split(":")[1];
            String fieldId = dataArray[2].split(":")[1].equals("null") ? "" : dataArray[2].split(":")[1];
            allowedTypes = dataArray[3].split(":")[1].equals("null") ? "" : dataArray[3].split(":")[1];
            applicationId = dataArray[4].split(":")[1].equals("null") ? "" : dataArray[4].split(":")[1];
            String userId = Security.getDesignerIdFromToken((HttpServletRequest)request);
            if (path.indexOf("/") == 0) {
                path = path.substring(1);
            }
            String savePath = PropertyUtil.getPath();
            File f1 = new File(savePath = savePath + this.getUploadInfo(excludeTypesString.toString(), uploadContentType, uploadFileName, fileSaveMode, path).getFileDir());
            if (!f1.exists() && !f1.mkdirs()) {
                Log.warn("Failed to create folder (" + savePath + ")");
                throw new IOException("Failed to create folder (" + savePath + ")");
            }
            DiskFileItemFactory fac = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
            upload.setHeaderEncoding("utf-8");
            List fileList = null;
            try {
                fileList = upload.parseRequest(request);
            }
            catch (FileUploadException ex) {
                ex.printStackTrace();
                throw ex;
            }
            Iterator it = fileList.iterator();
            String fileName = "";
            String extName = "";
            long size = 0L;
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (item.isFormField()) continue;
                fileName = item.getName().substring(0, item.getName().lastIndexOf("."));
                fileName = fileName.replace(" ", "");
                fileName = URLDecoder.decode(fileName, "UTF-8");
                extName = item.getName().substring(item.getName().lastIndexOf("."));
                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
                }
                if (path.equals("EXCELTEMPLATE_PATH") && extName.indexOf(".xls") < 0 && extName.indexOf(".xlsx") < 0) {
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
                }
                if (this.isNotLegalFileExt(extName)) {
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
                }
                size = item.getSize();
                if (item.getName() == null || item.getName().trim().equals("") || item.getName().trim().equals("null")) continue;
                if (item.getName().lastIndexOf(".") >= 0) {
                    uploadFileName = fileName + extName;
                    uploadContentType = allowedTypes + "/" + item.getName().substring(item.getName().lastIndexOf(".") + 1);
                }
                uploadInfo = this.getUploadInfo(excludeTypesString.toString(), uploadContentType, uploadFileName, fileSaveMode, path);
                this.reName(uploadInfo, 0, fileName, extName);
                try {
                    File saveFile = new File(uploadInfo.getFileRealSavePath());
                    item.write(saveFile);
                    if (applicationId == null || applicationId.equals("")) continue;
                    UploadProcess uploadProcess = RunTimeServiceManager.uploadProcess((String)applicationId);
                    uuid = UUID.randomUUID().toString();
                    UploadVO uploadVO = new UploadVO();
                    uploadVO.setId(uuid);
                    uploadVO.setName(uploadInfo.getFileName());
                    uploadVO.setFieldid(fieldId);
                    uploadVO.setType(extName);
                    uploadVO.setSize(size);
                    uploadVO.setModifyDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                    uploadVO.setUserid(userId);
                    uploadVO.setPath(uploadInfo.getWebPath());
                    uploadVO.setFolderPath(uploadInfo.getFileDir());
                    uploadProcess.doCreate(uploadVO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().print(uploadInfo.getWebPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void reName(UploadInfo uploadInfo, int i, String fileName, String extName) {
        File file = new File(uploadInfo.getFileRealSavePath());
        if (file.exists()) {
            uploadInfo.setFileName(fileName + ++i + extName);
            this.reName(uploadInfo, i, fileName, extName);
        }
    }

    protected String filter(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        if (sb.indexOf("_") != -1) {
            sb.deleteCharAt(sb.indexOf("_"));
            this.filter(sb.toString());
        }
        return sb.toString();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UploadInfo getUploadInfo(String allowedTypes, String uploadContentType, String uploadFileName, String fileSaveMode, String path) {
        UploadInfo uploadInfo = new UploadInfo();
        uploadInfo.setAllowedTypes(allowedTypes);
        uploadInfo.setContentType(uploadContentType);
        uploadInfo.setFileName(uploadFileName);
        uploadInfo.setFileSaveMode(fileSaveMode);
        try {
            uploadInfo.setPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uploadInfo;
    }

    private boolean isNotLegalFileExt(String fileExt) throws Exception {
        String fileType = fileExt.substring(1);
        String[] tempExcludeTypes = this.getExcludeTypes();
        for (int i = 0; i < tempExcludeTypes.length; ++i) {
            String excludeType = tempExcludeTypes[i];
            if (StringUtil.isBlank((String)excludeType) || !fileType.equalsIgnoreCase(excludeType)) continue;
            return true;
        }
        return false;
    }
}

