/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.statelabel.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.statelabel.service.StateLabelService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6807\u7b7e\u72b6\u6001\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class StateLabelController
extends AbstractDesignTimeController {
    private StateLabelService stateLabelService = DesignTimeServiceManager.stateLabelService();

    @GetMapping(path={"/{applicationId}/statelabels"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u5217\u8868", notes="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="searchword", value="\u67e5\u8be2\u540d\u79f0\u6216\u8005\u63cf\u8ff0", required=true, paramType="query", dataType="string")})
    public Resource getStateLabelsList(@PathVariable String applicationId, String searchword, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.stateLabelService.queryByNameOrDescript(applicationId, searchword, page, line);
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            for (StateLabel stateLabel : data.getDatas()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"id", (Object)stateLabel.getId());
                jsonObject.put((Object)"name", (Object)stateLabel.getName());
                jsonObject.put((Object)"description", (Object)stateLabel.getDescription());
                jsonObject.put((Object)"value", (Object)stateLabel.getValue());
                jsonObject.put((Object)"orderNo", (Object)stateLabel.getOrderNo());
                array.add((Object)jsonObject);
            }
            result.put((Object)"linesPerPage", (Object)data.getLinesPerPage());
            result.put((Object)"pageCount", (Object)data.getPageCount());
            result.put((Object)"pageNo", (Object)data.getPageNo());
            result.put((Object)"rowCount", (Object)data.getRowCount());
            result.put((Object)"data", (Object)array);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/statelabels/{stateLabelId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u8be6\u60c5", notes="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="stateLabelId", value="\u6807\u7b7e\u72b6\u6001id", required=true, paramType="path", dataType="string")})
    public Resource doGetStateLabel(@PathVariable String stateLabelId) {
        try {
            StateLabel stateLabel = (StateLabel)this.stateLabelService.findById(stateLabelId);
            return this.success("ok", stateLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/statelabels"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u6807\u7b7e\u72b6\u6001", notes="\u65b0\u5efa\u6807\u7b7e\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateStateLabels(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            StateLabel stateLabel = (StateLabel)this.json2obj(json, StateLabel.class);
            stateLabel.setApplicationid(applicationId);
            stateLabel.setParentId(applicationId);
            if (StringUtil.isBlank((String)stateLabel.getId())) {
                stateLabel.setId(Sequence.getDesignTimeSequence());
            }
            if (stateLabel.getName().equals("")) {
                throw new OBPMValidateException("{*[page.name.notexist]*}");
            }
            String regEx = "[ \\~\\!\\/\\@\\#\\$\\%\\^\\&\\*\\(\\)\\-\\=\\+\\\\\\|\\[\\{\\}\\]\\;\\:\\'\\\"\\,\\<\\.\\>\\/\\?]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(stateLabel.getName());
            if (m.find()) {
                throw new OBPMValidateException("{*[Name]*}{*[can.not.exist.invalidchar]*}");
            }
            this.doSaveValidate(stateLabel);
            this.stateLabelService.save((Object)stateLabel);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)stateLabel.getId());
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/statelabels"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6807\u7b7e\u72b6\u6001", notes="\u66f4\u65b0\u6807\u7b7e\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateStateLabels(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            StateLabel stateLabel = (StateLabel)this.json2obj(json, StateLabel.class);
            this.doSaveValidate(stateLabel);
            this.stateLabelService.saveOrUpdate((Object)stateLabel);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/statelabels"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6807\u7b7e\u72b6\u6001", notes="\u5220\u9664\u6807\u7b7e\u72b6\u6001\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteStateLabels(@RequestBody String[] ids) {
        try {
            this.stateLabelService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(StateLabel stateLabel) throws Exception {
        List list = this.stateLabelService.list(stateLabel.getApplicationid(), stateLabel.getName());
        for (StateLabel label : list) {
            if (stateLabel.getId().equals(label.getId()) && stateLabel.getName().equals(label.getName())) break;
            if (!label.getName().equals(stateLabel.getName())) continue;
            throw new OBPMValidateException(" \u8be5\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u547d\u540d\u518d\u4fdd\u5b58\uff01 ");
        }
    }
}

