/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.page.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.page.Page;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.page.service.PageDesignTimeService;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u9875\u9762\u64cd\u4f5c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class PageDesignTimeController
extends AbstractDesignTimeController {
    private PageDesignTimeService pageService = DesignTimeServiceManager.pageDesignTimeService();

    @GetMapping(path={"/{applicationId}/pages"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u5217\u8868", notes="\u83b7\u53d6\u9875\u9762\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=false, paramType="query", dataType="int")})
    public Resource getPages(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false) String requestType, @RequestParam(required=false) String status, @RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="10") int linesPerPage) {
        try {
            DataPackage result = this.pageService.query(applicationId, name, pageNo, linesPerPage);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/pages/{pageId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u8be6\u60c5", notes="\u83b7\u53d6\u9875\u9762\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageId", value="\u4e3b\u952e", required=true, paramType="path", dataType="string")})
    public Resource getPage(@PathVariable String pageId) throws Exception {
        try {
            Page page = (Page)this.pageService.findById(pageId);
            return this.success("ok", page);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/pages"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u9875\u9762", notes="\u65b0\u5efa\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createPage(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Page page = (Page)this.json2obj(json, Page.class);
            page.setApplicationid(applicationId);
            page.setParentId(applicationId);
            this.doSaveValidate(page);
            this.pageService.saveOrUpdate((Object)page);
            JSONObject pageJson = new JSONObject();
            pageJson.put((Object)"id", (Object)page.getId());
            return this.success("ok", pageJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/pages/{pageId}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u66f4\u65b0\u9875\u9762", notes="\u66f4\u65b0\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updatePage(@PathVariable String applicationId, @PathVariable String pageId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Page pg = (Page)this.json2obj(json, Page.class);
            Page oldPage = (Page)this.pageService.findById(pageId);
            Page page = (Page)BeanUtils.cloneBean((Object)oldPage);
            page.setApplicationid(applicationId);
            page.setName(pg.getName());
            page.setTemplateContext(pg.getTemplateContext());
            this.doSaveValidate(page);
            this.pageService.saveOrUpdate((Object)page);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/pages"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u9875\u9762\uff08\u53ef\u6279\u91cf\uff09", notes="\u5220\u9664\u9875\u9762\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteEips(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.pageService.delete(idArray);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(Page pg) throws Exception {
        List list = this.pageService.list(pg.getParentId(), pg.getName());
        if (StringUtils.isBlank((String)pg.getId())) {
            for (Page page : list) {
                if (!page.getName().equals(pg.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (Page page : list) {
                if (page.getId().equals(pg.getId()) || !page.getName().equals(pg.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
    }
}

