/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.workflow.element.AutoNode;
import cn.myapps.runtime.workflow.element.CompleteNode;
import cn.myapps.runtime.workflow.element.EndNode;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.element.Relation;
import cn.myapps.runtime.workflow.element.StartNode;
import cn.myapps.runtime.workflow.element.SubFlow;
import cn.myapps.runtime.workflow.element.SuspendNode;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class WorkFlowOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell wc = new Cell();
            wc.setBackgroundColor(Color.gray);
            wc.addElement((Element)new Paragraph("\u6d41\u7a0b\uff1a", fontChinese));
            table.addCell(wc);
            ModuleDesignTimeService moduleDesignTimeService = (ModuleDesignTimeService)DesignTimeServiceFactory.resolve(ModuleDesignTimeService.class);
            List moduleList = moduleDesignTimeService.list(applicationId, null);
            BillDefiDesignTimeService bp = (BillDefiDesignTimeService)DesignTimeServiceFactory.resolve(BillDefiDesignTimeService.class);
            ArrayList billdefis = new ArrayList();
            if (moduleList != null && moduleList.size() > 0) {
                for (Module m : moduleList) {
                    List billDefiVOList = bp.list(m.getId(), null);
                    if (billDefiVOList == null || billDefiVOList.size() <= 0) continue;
                    billdefis.addAll(billDefiVOList);
                }
            }
            if (billdefis != null) {
                wc = new Cell();
                Iterator it = billdefis.iterator();
                Table bTable = new Table(1);
                bTable.setWidth(99.0f);
                bTable.setPadding(0.0f);
                bTable.setSpacing(0.0f);
                bTable.setBorderWidth(1.0f);
                Cell b_cell = null;
                while (it.hasNext()) {
                    BillDefiVO bd = (BillDefiVO)it.next();
                    if (bd == null) continue;
                    b_cell = new Cell();
                    Table bt = new Table(1);
                    bt.setWidth(99.0f);
                    bt.setPadding(0.0f);
                    bt.setSpacing(0.0f);
                    bt.setBorderWidth(1.0f);
                    Cell cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    String bName = bd.getSubject();
                    cell.addElement((Element)new Paragraph("\u6d41\u7a0b\u540d\u79f0\uff1a" + (bName != null ? bName : ""), fontChinese));
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph("\u8282\u70b9\u4fe1\u606f\uff1a", fontChinese));
                    Table nTable = this.createNode(bd);
                    if (nTable != null) {
                        cell.addElement((Element)nTable);
                    }
                    bt.addCell(cell);
                    cell = new Cell();
                    cell.addElement((Element)new Paragraph("\u8def\u5f84\u4fe1\u606f\uff1a", fontChinese));
                    Table rTable = this.createRelation(bd);
                    if (rTable != null) {
                        cell.addElement((Element)rTable);
                    }
                    bt.addCell(cell);
                    b_cell.addElement((Element)bt);
                    bTable.addCell(b_cell);
                }
                wc.addElement((Element)bTable);
                table.addCell(wc);
            }
        }
        return table;
    }

    private Table createNode(BillDefiVO bd) throws Exception {
        if (bd != null) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            FlowDiagram fd = bd.toFlowDiagram();
            Vector elements = fd.getAllElements();
            Table nt = new Table(6);
            nt.setWidth(99.0f);
            nt.setPadding(0.0f);
            nt.setSpacing(0.0f);
            nt.setBorderWidth(1.0f);
            if (elements != null) {
                Iterator it = elements.iterator();
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u8282\u70b9\u540d\u79f0", fontChinese));
                nt.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                nt.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u72b6\u6001\u6807\u7b7e", fontChinese));
                nt.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                nt.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u662f\u5426\u5206\u6563", fontChinese));
                nt.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u662f\u5426\u805a\u5408", fontChinese));
                nt.addCell(cell);
                while (it.hasNext()) {
                    ManualNode mNode;
                    cn.myapps.runtime.workflow.element.Element element = (cn.myapps.runtime.workflow.element.Element)it.next();
                    if (!(element instanceof Node)) continue;
                    Node node = (Node)element;
                    cell = new Cell();
                    String nName = node.name;
                    cell.addElement((Element)new Paragraph(nName != null ? nName : "", fontChinese));
                    nt.addCell(cell);
                    cell = new Cell();
                    String nType = "";
                    if (node instanceof AutoNode) {
                        nType = "\u81ea\u52a8\u8282\u70b9";
                    } else if (node instanceof CompleteNode) {
                        nType = "\u5b8c\u6210\u8282\u70b9";
                    } else if (node instanceof ManualNode) {
                        nType = "\u4eba\u5de5\u8282\u70b9";
                    } else if (node instanceof StartNode) {
                        nType = "\u5f00\u59cb\u8282\u70b9";
                    } else if (node instanceof SubFlow) {
                        nType = "\u5b50\u6d41\u7a0b\u8282\u70b9";
                    } else if (node instanceof SuspendNode) {
                        nType = "\u6302\u8d77\u8282\u70b9";
                    }
                    cell.addElement((Element)new Paragraph(nType != null ? nType : "", fontChinese));
                    nt.addCell(cell);
                    cell = new Cell();
                    String statelabel = node.statelabel;
                    cell.addElement((Element)new Paragraph(statelabel != null ? statelabel : "", fontChinese));
                    nt.addCell(cell);
                    cell = new Cell();
                    String description = "";
                    cell.addElement((Element)new Paragraph(description != null ? description : "", fontChinese));
                    nt.addCell(cell);
                    cell = new Cell();
                    Vector rns = fd.getNodeNextRelation(node);
                    String dispersion = "\u5426";
                    if (rns != null && rns.size() > 1 && !(node instanceof StartNode)) {
                        dispersion = "\u662f";
                    }
                    cell.addElement((Element)new Paragraph(dispersion != null ? dispersion : "", fontChinese));
                    nt.addCell(cell);
                    cell = new Cell();
                    Vector rbs = fd.getNodeBeforeRelation(node, false);
                    String poly = "\u5426";
                    if (rbs != null && rbs.size() > 1 && !(node instanceof EndNode) && !(node instanceof CompleteNode)) {
                        poly = "\u662f";
                    }
                    cell.addElement((Element)new Paragraph(poly != null ? poly : "", fontChinese));
                    nt.addCell(cell);
                    if (node instanceof ManualNode) {
                        cell = new Cell();
                        cell.setColspan(6);
                        mNode = (ManualNode)node;
                        String namelist = mNode.namelist;
                        cell.addElement((Element)new Paragraph("\u5ba1\u6279\u4eba\uff1a\n" + (namelist != null ? namelist : ""), fontChinese));
                        nt.addCell(cell);
                    }
                    if (!(node instanceof ManualNode)) continue;
                    mNode = (ManualNode)node;
                    String actorListScript = mNode.actorListScript;
                    if (StringUtil.isBlank((String)actorListScript)) continue;
                    cell = new Cell();
                    cell.setColspan(6);
                    cell.addElement((Element)new Paragraph("\u5ba1\u6279\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)actorListScript), fontChinese));
                    nt.addCell(cell);
                }
            }
            return nt;
        }
        return null;
    }

    private Table createRelation(BillDefiVO bd) throws Exception {
        if (bd != null) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            FlowDiagram fd = bd.toFlowDiagram();
            Vector elements = fd.getAllElements();
            if (elements != null && elements.size() > 0) {
                Table rTable = new Table(3);
                rTable.setWidth(99.0f);
                rTable.setPadding(0.0f);
                rTable.setSpacing(0.0f);
                rTable.setBorderWidth(1.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u8def\u5f84\u540d\u79f0", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u6a21\u5f0f", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u63cf\u8ff0", fontChinese));
                rTable.addCell(cell);
                for (cn.myapps.runtime.workflow.element.Element element : elements) {
                    String validateScript;
                    String condition;
                    if (!(element instanceof Relation)) continue;
                    Relation relation = (Relation)element;
                    if (!StringUtil.isBlank((String)relation.name) || !StringUtil.isBlank((String)relation.editMode)) {
                        cell = new Cell();
                        String rName = relation.name;
                        cell.addElement((Element)new Paragraph(rName != null ? rName : "", fontChinese));
                        rTable.addCell(cell);
                        cell = new Cell();
                        String editMode = "";
                        if ("00".equals(relation.editMode)) {
                            editMode = "\u8bbe\u8ba1\u6a21\u5f0f";
                        } else if ("01".equals(relation.editMode)) {
                            editMode = "\u4ee3\u7801\u6a21\u5f0f";
                        }
                        cell.addElement((Element)new Paragraph(editMode != null ? editMode : "", fontChinese));
                        rTable.addCell(cell);
                        cell = new Cell();
                        String description = "";
                        cell.addElement((Element)new Paragraph(description != null ? description : "", fontChinese));
                        rTable.addCell(cell);
                    }
                    if ("00".equals(relation.editMode)) {
                        String processDescription = relation.processDescription;
                        if (!StringUtil.isBlank((String)processDescription)) {
                            cell = new Cell();
                            cell.setColspan(3);
                            cell.addElement((Element)new Paragraph("\u8def\u5f84\u8fdb\u5165\u6761\u4ef6\uff08\u8bbe\u8ba1\u6a21\u5f0f\uff09\uff1a\n" + StringUtil.dencodeHTML((String)processDescription), fontChinese));
                            rTable.addCell(cell);
                        }
                    } else if ("01".equals(relation.editMode) && !StringUtil.isBlank((String)(condition = relation.condition))) {
                        cell = new Cell();
                        cell.setColspan(3);
                        cell.addElement((Element)new Paragraph("\u8def\u5f84\u8fdb\u5165\u6761\u4ef6\uff08\u4ee3\u7801\u6a21\u5f0f\uff09\uff1a\n" + StringUtil.dencodeHTML((String)condition), fontChinese));
                        rTable.addCell(cell);
                    }
                    String action = relation.action;
                    if (!StringUtil.isBlank((String)action)) {
                        cell = new Cell();
                        cell.setColspan(3);
                        cell.addElement((Element)new Paragraph("\u8def\u5f84\u6267\u884c\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)action), fontChinese));
                        rTable.addCell(cell);
                    }
                    if (StringUtil.isBlank((String)(validateScript = relation.validateScript))) continue;
                    cell = new Cell();
                    cell.setColspan(3);
                    cell.addElement((Element)new Paragraph("\u8def\u5f84\u9001\u51fa\u6821\u9a8c\u811a\u672c\uff1a\n" + StringUtil.dencodeHTML((String)validateScript), fontChinese));
                    rTable.addCell(cell);
                }
                return rTable;
            }
        }
        return null;
    }
}

