/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.style.repository.service.StyleRepositoryDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class StyleReposityOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell sc = new Cell();
            sc.setBackgroundColor(Color.gray);
            sc.addElement((Element)new Paragraph("\u6837\u5f0f\u5e93\uff1a", fontChinese));
            table.addCell(sc);
            sc = new Cell();
            StyleRepositoryDesignTimeService srp = DesignTimeServiceManager.styleRepositoryDesignTimeService();
            List styleRepositories = srp.list(applicationId, null);
            if (styleRepositories != null && styleRepositories.size() > 0) {
                Table srTable = new Table(2);
                srTable.setPadding(0.0f);
                srTable.setSpacing(0.0f);
                srTable.setBorderWidth(1.0f);
                srTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                srTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7248\u672c", fontChinese));
                srTable.addCell(cell);
                for (StyleRepositoryVO styleRepository : styleRepositories) {
                    cell = new Cell();
                    String srName = styleRepository.getName();
                    cell.addElement((Element)new Paragraph(srName != null ? srName : "", fontChinese));
                    srTable.addCell(cell);
                    cell = new Cell();
                    int version = styleRepository.getVersion();
                    cell.addElement((Element)new Paragraph(String.valueOf(version), fontChinese));
                    srTable.addCell(cell);
                    cell = new Cell();
                    cell.setColspan(2);
                    String content = styleRepository.getContent();
                    cell.addElement((Element)new Paragraph("\u5185\u5bb9\uff1a\n" + (content != null ? content : ""), fontChinese));
                    srTable.addCell(cell);
                }
                sc.addElement((Element)srTable);
                table.addCell(sc);
            }
        }
        return table;
    }
}

