/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.statelabel.service.StateLabelService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class StateLabelOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell sc = new Cell();
            sc.setBackgroundColor(Color.gray);
            sc.addElement((Element)new Paragraph("\u72b6\u6001\u6807\u7b7e\uff1a", fontChinese));
            table.addCell(sc);
            sc = new Cell();
            StateLabelService sp = DesignTimeServiceManager.stateLabelService();
            List statelabels = sp.list(applicationId, null);
            if (statelabels != null && statelabels.size() > 0) {
                Table sTable = new Table(3);
                sTable.setPadding(0.0f);
                sTable.setSpacing(0.0f);
                sTable.setBorderWidth(1.0f);
                sTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                sTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u503c", fontChinese));
                sTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u6392\u5e8f\u53f7", fontChinese));
                sTable.addCell(cell);
                for (StateLabel statelabel : statelabels) {
                    cell = new Cell();
                    String sName = statelabel.getName();
                    cell.addElement((Element)new Paragraph(sName != null ? sName : "", fontChinese));
                    sTable.addCell(cell);
                    cell = new Cell();
                    String sValue = statelabel.getValue();
                    cell.addElement((Element)new Paragraph(sValue != null ? sValue : "", fontChinese));
                    sTable.addCell(cell);
                    cell = new Cell();
                    String orderno = statelabel.getOrderNo();
                    cell.addElement((Element)new Paragraph(orderno != null ? orderno : "", fontChinese));
                    sTable.addCell(cell);
                    cell = new Cell();
                    cell.setColspan(3);
                    String description = statelabel.getDescription();
                    cell.addElement((Element)new Paragraph("\u63cf\u8ff0\uff1a\n" + (description != null ? description : ""), fontChinese));
                    sTable.addCell(cell);
                }
                sc.addElement((Element)sTable);
                table.addCell(sc);
            }
        }
        return table;
    }
}

