/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Collection;

public class DeveloperOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell dc = new Cell();
            dc.setBackgroundColor(Color.gray);
            dc.addElement((Element)new Paragraph("\u5f00\u53d1\u8005\uff1a", fontChinese));
            table.addCell(dc);
            ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
            Application application = (Application)appService.findById(applicationId);
            if (application != null) {
                dc = new Cell();
                Table oTable = new Table(3);
                oTable.setPadding(0.0f);
                oTable.setSpacing(0.0f);
                oTable.setBorderWidth(1.0f);
                oTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                oTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u8d26\u53f7", fontChinese));
                oTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7535\u5b50\u90ae\u7bb1", fontChinese));
                oTable.addCell(cell);
                Collection owners = application.getOwners();
                if (owners != null && owners.size() > 0) {
                    for (SuperUserVO owner : owners) {
                        if (owner == null) continue;
                        cell = new Cell();
                        String oName = owner.getName();
                        cell.addElement((Element)new Paragraph(oName != null ? oName : "", fontChinese));
                        oTable.addCell(cell);
                        cell = new Cell();
                        String loginno = owner.getLoginno();
                        cell.addElement((Element)new Paragraph(loginno != null ? loginno : "", fontChinese));
                        oTable.addCell(cell);
                        cell = new Cell();
                        String email = owner.getEmail();
                        cell.addElement((Element)new Paragraph(email != null ? email : "", fontChinese));
                        oTable.addCell(cell);
                    }
                    dc.addElement((Element)oTable);
                    table.addCell(dc);
                }
            }
        }
        return table;
    }
}

