/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.Date;

public class ApplicationOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        ApplicationDesignTimeService appService;
        Application avo;
        Table appTable = new Table(1);
        appTable.setPadding(0.0f);
        appTable.setSpacing(0.0f);
        appTable.setBorderWidth(1.0f);
        appTable.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId) && (avo = (Application)(appService = DesignTimeServiceManager.applicationDesignTimeService()).findById(applicationId)) != null) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell cell = new Cell();
            cell.setBackgroundColor(Color.gray);
            cell.addElement((Element)new Paragraph("\u8f6f\u4ef6\u57fa\u672c\u4fe1\u606f\uff1a", fontChinese));
            appTable.addCell(cell);
            cell = new Cell();
            cell.setBorderWidth(0.0f);
            String appName = avo.getName();
            Date createTime = avo.getCreateDate();
            DataSource datasource = avo.getDataSourceDefine();
            String description = avo.getDescription();
            cell.addElement((Element)new Paragraph("\u8f6f\u4ef6\u540d\u79f0\uff1a" + (appName != null ? appName : ""), fontChinese));
            cell.addElement((Element)new Paragraph("\u521b\u5efa\u65f6\u95f4\uff1a" + (createTime != null ? createTime.toString() : ""), fontChinese));
            cell.addElement((Element)new Paragraph("\u4f5c\u8005\uff1a", fontChinese));
            cell.addElement((Element)new Paragraph("\u6570\u636e\u6e90\uff1a" + (datasource != null ? datasource.getUrl() : ""), fontChinese));
            cell.addElement((Element)new Paragraph("\u63cf\u8ff0\uff1a" + (description != null ? description : ""), fontChinese));
            appTable.addCell(cell);
        }
        return appTable;
    }
}

