/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.Environment;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.overview.OverviewFactory;
import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractOverviewBuilder {
    public void buildOverview(String applicationId, String pdfFileName) throws Exception {
        String path = Environment.getInstance().getRealPath("/uploads");
        if ((path = path + "/overview/") != null) {
            Iterator<IOverview> it;
            File file;
            File f1 = new File(path);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            if (!(file = new File(path + pdfFileName)).exists() && !file.createNewFile()) {
                throw new OBPMValidateException("Create pdf file [" + path + pdfFileName + "] failed");
            }
            Document document = new Document(PageSize.A4.rotate(), 5.0f, 5.0f, 30.0f, 30.0f);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            Table table = new Table(1);
            table.setPadding(2.0f);
            table.setSpacing(0.0f);
            table.setBorderWidth(1.0f);
            Collection<IOverview> overviers = OverviewFactory.createAllOverview();
            if (overviers != null && (it = overviers.iterator()) != null) {
                while (it.hasNext()) {
                    IOverview overview = it.next();
                    Cell cell = new Cell();
                    Table t = overview.buildOverview(applicationId);
                    cell.addElement((Element)t);
                    table.addCell(cell);
                }
            }
            document.add((Element)table);
            document.close();
        }
    }
}

