/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.multilanguage.controller;

import cn.myapps.common.model.multilanguage.MultiLanguage;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.multilanguage.service.MultiLanguageService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u591a\u8bed\u8a00\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class MulitLanguageController
extends AbstractDesignTimeController {
    private MultiLanguageService multiLanguageService = DesignTimeServiceManager.multiLanguageService();

    @GetMapping(path={"/{applicationId}/mulitlangs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u591a\u8bed\u8a00\u5217\u8868", notes="\u83b7\u53d6\u591a\u8bed\u8a00\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="label", value="\u6807\u7b7e", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="text", value="\u6587\u672c", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=false, paramType="query", dataType="int")})
    public Resource getMulitlangsList(@PathVariable String applicationId, String pageNo, String linesPerPage, String label, String text, @RequestParam(required=false, defaultValue="0") int type) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        List multilanguageList = null;
        try {
            multilanguageList = this.multiLanguageService.list(applicationId, "");
            Iterator multilanguageListTemp = multilanguageList.iterator();
            while (multilanguageListTemp.hasNext()) {
                MultiLanguage multiLanguage = (MultiLanguage)multilanguageListTemp.next();
                if (!cn.myapps.common.util.StringUtil.isBlank((String)text) && !multiLanguage.getText().contains(text)) {
                    multilanguageListTemp.remove();
                    continue;
                }
                if (!cn.myapps.common.util.StringUtil.isBlank((String)label) && !multiLanguage.getLabel().contains(label)) {
                    multilanguageListTemp.remove();
                    continue;
                }
                if (type == 0 || multiLanguage.getType() == type) continue;
                multilanguageListTemp.remove();
            }
            int beginIndex = (page - 1) * line;
            int endIndex = page * line;
            int rowCount = multilanguageList.size();
            if (beginIndex >= multilanguageList.size()) {
                multilanguageList = null;
                rowCount = 0;
            } else if (endIndex >= multilanguageList.size()) {
                endIndex = multilanguageList.size();
            }
            if (multilanguageList != null && multilanguageList.size() > 0) {
                multilanguageList = multilanguageList.subList(beginIndex, endIndex);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("linesPerPage", line);
            result.put("pageCount", (int)Math.ceil((double)rowCount / (double)line));
            result.put("pageNo", page);
            result.put("rowCount", rowCount);
            result.put("data", multilanguageList);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/mulitlangs/{mulitlangId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u591a\u8bed\u8a00\u8be6\u60c5", notes="\u83b7\u53d6\u591a\u8bed\u8a00\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mulitlangId", value="\u591a\u8bed\u8a00id", required=true, paramType="path", dataType="string")})
    public Resource doGetMulitlang(@PathVariable String mulitlangId) {
        try {
            MultiLanguage multiLanguage = (MultiLanguage)this.multiLanguageService.findById(mulitlangId);
            return this.success("ok", multiLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(value={"/{applicationId}/mulitlangs"})
    @ApiOperation(value="\u65b0\u5efa\u591a\u8bed\u8a00", notes="\u65b0\u5efa\u591a\u8bed\u8a00")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createMulitlang(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            MultiLanguage multiLanguage = (MultiLanguage)this.json2obj(json, MultiLanguage.class);
            multiLanguage.setParentId(applicationId);
            multiLanguage.setApplicationid(applicationId);
            multiLanguage.setName(multiLanguage.getText());
            if (StringUtil.isBlank((String)multiLanguage.getId())) {
                multiLanguage.setId(Sequence.getDesignTimeSequence());
            }
            this.multiLanguageService.save((Object)multiLanguage);
            MultiLanguageProperty.putLanguage((String)applicationId, (MultiLanguage)multiLanguage);
            JSONObject result = new JSONObject();
            result.put((Object)"id", (Object)multiLanguage.getId());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/mulitlangs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u51fd\u6570\u5e93", notes="\u66f4\u65b0\u51fd\u6570\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateMulitlangs(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            MultiLanguage multiLanguage = (MultiLanguage)this.json2obj(json, MultiLanguage.class);
            multiLanguage.setName(multiLanguage.getText());
            this.multiLanguageService.saveOrUpdate((Object)multiLanguage);
            MultiLanguageProperty.putLanguage((String)multiLanguage.getApplicationid(), (MultiLanguage)multiLanguage);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/mulitlangs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u591a\u8bed\u8a00", notes="\u5220\u9664\u591a\u8bed\u8a00\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteMulitlangs(@RequestBody String[] ids) {
        try {
            this.multiLanguageService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/reloadLanguage"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u8bed\u8a00\u5c5e\u6027", notes="\u91cd\u65b0\u52a0\u8f7d\u8bed\u8a00\u5c5e\u6027")
    public Resource reloadLanguage() {
        try {
            MultiLanguageProperty.init();
            return this.success("ok", "\u52a0\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

