/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.menu.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.Environment;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.resource.ResourceType;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public class ResourceHelper {
    protected String applicationid = null;
    protected String moduleid = null;
    public ResourceDesignTimeService process = null;

    public ResourceHelper() {
        try {
            this.process = DesignTimeServiceManager.resourceDesignTimeService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getApplicationid() {
        return this.applicationid;
    }

    public void setApplicationid(String applicationid) {
        this.applicationid = applicationid;
    }

    public String getModuleid() {
        return this.moduleid;
    }

    public void setModuleid(String moduleid) {
        this.moduleid = moduleid;
    }

    public String getName(String type) {
        String name = ResourceType.getName((String)type);
        return name;
    }

    public Map<String, String> get_ExcelImportCfgList(String application) throws Exception {
        IMPMappingConfigDesignTimeService ep = DesignTimeServiceManager.impMappingConfigDesignTimeService();
        Collection col = ep.getAllMappingConfig(application);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (IMPMappingConfigVO em : col) {
            map.put(em.getId(), em.getName());
        }
        return map;
    }

    public Map<String, String> get_AllLinkType() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        map.put(ResourceVO.LinkType.FORM.getCode(), "{*[Form]*}");
        map.put(ResourceVO.LinkType.VIEW.getCode(), "{*[View]*}");
        map.put(ResourceVO.LinkType.REPORT.getCode(), "{*[cn.myapps.core.resource.report]*}");
        map.put(ResourceVO.LinkType.CUSTOMIZE_REPORT.getCode(), "{*[cn.myapps.core.resource.customize_report]*}");
        map.put(ResourceVO.LinkType.RUNQIAN_REPORT.getCode(), "{*[cn.myapps.core.resource.raq_report]*}");
        map.put(ResourceVO.LinkType.EXCELIMPORT.getCode(), "{*[cn.myapps.core.resource.excel_import]*}");
        map.put(ResourceVO.LinkType.MANUAL_INTERNAL.getCode(), "{*[cn.myapps.core.resource.customize_links_internal]*}");
        map.put(ResourceVO.LinkType.MANUAL_EXTERNAL.getCode(), "{*[cn.myapps.core.resource.customize_links_external]*}");
        map.put(ResourceVO.LinkType.SCRIPT.getCode(), "{*[cn.myapps.core.resource.script_links]*}");
        map.put(ResourceVO.LinkType.EMAIL.getCode(), "{*[cn.myapps.core.resource.email_links]*}");
        map.put(ResourceVO.LinkType.BBS.getCode(), "{*[Forum.Links]*}");
        map.put(ResourceVO.LinkType.NetworkDisk.getCode(), "{*[cn.myapps.core.resource.network_disk_links]*}");
        return map;
    }

    public Map<String, String> get_MbLinkType() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        map.put(ResourceVO.LinkType.FORM.getCode(), "{*[Form]*}");
        map.put(ResourceVO.LinkType.VIEW.getCode(), "{*[View]*}");
        return map;
    }

    public Collection<ResourceVO> deepSearchResouece(String resourceid) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        ResourceVO start = rp.doView(resourceid);
        if (start != null) {
            Collection allResource = rp.doSimpleQuery(null, this.getApplicationid());
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, start, null, 0);
            rtn.add(start);
            for (ResourceVO res : underlist) {
                rtn.add(res);
            }
        }
        return rtn;
    }

    public Collection<ResourceVO> searchSubResource(String resourceid, int deep, String domain, String applicationid) throws Exception {
        if (StringUtil.isBlank((String)this.getApplicationid())) {
            this.setApplicationid(applicationid);
        }
        return this.searchSubResource(resourceid, deep, domain);
    }

    @Deprecated
    public Collection<ResourceVO> searchSubResource(String resourceid, int deep, String domain) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        ResourceVO start = rp.doView(resourceid);
        if (start != null) {
            List allResource = rp.list(resourceid, null);
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, start, null, deep);
            for (ResourceVO res : underlist) {
                rtn.add(res);
            }
        }
        return rtn;
    }

    private Collection<ResourceVO> deepSearchResouece(Collection<ResourceVO> colls, ResourceVO startNode, String excludeNodeId, int deep) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        for (ResourceVO vo : colls) {
            Collection<ResourceVO> idList;
            if (startNode == null) {
                if (vo.getSuperior() != null) continue;
                if (deep == 1) {
                    rtn.add(vo);
                    continue;
                }
                if (vo.getId() == null || vo.getId().equals(excludeNodeId)) continue;
                rtn.add(vo);
                idList = this.deepSearchResouece(colls, vo, excludeNodeId, deep - 1);
                rtn.addAll(idList);
                continue;
            }
            if (vo.getSuperior() == null || !vo.getSuperior().equals(startNode.getId())) continue;
            if (deep == 1) {
                rtn.add(vo);
                continue;
            }
            if (vo.getId() == null || vo.getId().equals(excludeNodeId)) continue;
            rtn.add(vo);
            idList = this.deepSearchResouece(colls, vo, excludeNodeId, deep - 1);
            rtn.addAll(idList);
        }
        return rtn;
    }

    public Collection<ResourceVO> searchSubResource4flowCenter(String resourceid, int deep, String domain) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        ResourceVO start = rp.doView(resourceid);
        if (start != null) {
            List allResource = rp.list(start.getApplicationid(), null);
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, start, null, deep);
            for (ResourceVO res : underlist) {
                if (res.getType().equals("100") || res.getShowType() == 1) continue;
                rtn.add(res);
            }
        }
        return rtn;
    }

    public Collection<ResourceVO> searchSubResource4MobileflowCenter(String resourceid, int deep, String domain, String applicationId) throws Exception {
        if (StringUtil.isBlank((String)this.getApplicationid())) {
            this.setApplicationid(applicationId);
        }
        return this.searchSubResource4MobileflowCenter(resourceid, deep, domain);
    }

    @Deprecated
    public Collection<ResourceVO> searchSubResource4MobileflowCenter(String resourceid, int deep, String domain) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        ParamsTable params = new ParamsTable();
        params.setParameter("_orderby", (Object)"orderno");
        params.setParameter("xi_type", (Object)"10");
        params.setParameter("xi_showType", (Object)1);
        ResourceVO start = rp.doView(resourceid);
        if (start != null) {
            Collection allResource = rp.doSimpleQuery(params, this.getApplicationid());
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, start, null, deep);
            for (ResourceVO res : underlist) {
                rtn.add(res);
            }
        }
        return rtn;
    }

    public Collection<ResourceVO> searchMobileSubResource(String resourceid, int deep, String domain, String applicationId) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        ParamsTable params = new ParamsTable();
        params.setParameter("_orderby", (Object)"orderno");
        params.setParameter("xi_type", (Object)"10");
        params.setParameter("xi_showType", (Object)2);
        ResourceVO start = rp.doView(resourceid);
        if (start != null) {
            Collection allResource = rp.doSimpleQuery(params, applicationId);
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, start, null, deep);
            for (ResourceVO res : underlist) {
                rtn.add(res);
            }
        }
        return rtn;
    }

    public Collection<ResourceVO> searchResourceForMb(ResourceVO startNode, String domain) throws Exception {
        ArrayList<ResourceVO> rtn = new ArrayList<ResourceVO>();
        ResourceDesignTimeService rp = this.process;
        if (startNode != null) {
            ParamsTable params = new ParamsTable();
            params.setParameter("_orderby", (Object)"orderno");
            params.setParameter("s_type", (Object)"100");
            Collection allResource = rp.doSimpleQuery(params, this.getApplicationid());
            Collection<ResourceVO> underlist = this.deepSearchResouece(allResource, startNode, null, 1);
            block0: for (ResourceVO vo : underlist) {
                if (vo.getSuperior() == null) continue;
                ResourceVO superior = (ResourceVO)this.process.findById(vo.getSuperior());
                while (superior != null) {
                    if (superior.getId().equals(startNode.getId())) {
                        rtn.add(vo);
                        continue block0;
                    }
                    superior = (ResourceVO)this.process.findById(superior.getSuperior());
                }
            }
        }
        return rtn;
    }

    public ResourceVO getResourcById(String resourceid) throws Exception {
        ResourceDesignTimeService rp = this.process;
        return rp.doView(resourceid);
    }

    public Map<String, String> getMobileIcons() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] names = ResourceType.MOBILEICOS;
        String[] types = ResourceType.ICOTYPES;
        for (int i = 0; i < names.length; ++i) {
            map.put(types[i], names[i]);
        }
        return map;
    }

    public Map<String, String> getAllDomain() throws Exception {
        DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
        Collection domains = process.getAllDomain();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (domains.size() <= 0) {
            return map;
        }
        for (DomainVO domain : domains) {
            map.put(domain.getId(), domain.getName());
        }
        return map;
    }

    public Collection<IconLibFile> getIcons(String path) throws Exception {
        String contentPath;
        File dir;
        File[] files;
        ArrayList<IconLibFile> rtn = new ArrayList<IconLibFile>();
        Environment ev = Environment.getInstance();
        String string = path = StringUtil.isBlank((String)path) ? "uploads/lib/icon" : path;
        if (ev != null && (files = (dir = new File(contentPath = ev.getRealPath("") + "/" + path)).listFiles()) != null && files.length > 0) {
            DecimalFormat format = new DecimalFormat("#.##");
            for (int i = 0; i < files.length; ++i) {
                IconLibFile icon;
                if (files[i].isDirectory()) {
                    icon = new IconLibFile();
                    icon.setName(files[i].getName());
                    icon.setPath(path + "/" + files[i].getName());
                    icon.setFileType(2);
                    rtn.add(icon);
                    continue;
                }
                if (!this.isImageFile(files[i].getName())) continue;
                icon = new IconLibFile();
                BufferedImage bufferedImage = ImageIO.read(files[i]);
                icon.setSize(bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
                icon.setLength(format.format((double)files[i].length() / 1024.0) + " KB");
                icon.setName(files[i].getName());
                icon.setWidth(bufferedImage.getWidth());
                icon.setPath(path + "/" + files[i].getName());
                icon.setFileType(1);
                rtn.add(icon);
            }
        }
        return rtn;
    }

    public void createFolder(String name, String path) {
        String contentPath;
        File folder;
        Environment ev = Environment.getInstance();
        String string = path = StringUtil.isBlank((String)path) ? "lib/icon" : path;
        if (ev != null && !(folder = new File(contentPath = ev.getRealPath("") + path + "/" + name)).exists()) {
            folder.mkdirs();
        }
    }

    private boolean isImageFile(String name) {
        return (name = name.toLowerCase()).indexOf("png") >= 0 || name.indexOf("ico") >= 0 || name.indexOf(".gif") >= 0 || name.indexOf(".jpg") >= 0 || name.indexOf(".jpge") >= 0 || name.indexOf(".bmp") >= 0;
    }

    public class IconLibFile {
        public static final int IMAGE = 1;
        public static final int DIR = 2;
        private String name;
        private String size;
        private String length;
        private int width;
        private String path;
        private int fileType;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getLength() {
            return this.length;
        }

        public void setLength(String length) {
            this.length = length;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getFileType() {
            return this.fileType;
        }

        public void setFileType(int fileType) {
            this.fileType = fileType;
        }
    }
}

