/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.macro.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.macro.repository.service.RepositoryDesignTimeService;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u51fd\u6570\u5e93\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class MacrosController
extends AbstractDesignTimeController {
    private RepositoryDesignTimeService repositoryDesignTimeService = DesignTimeServiceManager.repositoryDesignTimeService();

    @GetMapping(path={"/{applicationId}/macros"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u51fd\u6570\u5e93\u5217\u8868", notes="\u83b7\u53d6\u51fd\u6570\u5e93\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u51fd\u6570\u5e93\u540d\u79f0", required=true, paramType="path", dataType="string")})
    public Resource getMacrosList(@PathVariable String applicationId, String name, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.repositoryDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/macros/{macroId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u51fd\u6570\u5e93\u8be6\u60c5", notes="\u83b7\u53d6\u51fd\u6570\u5e93\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="macroId", value="\u51fd\u6570\u5e93id", required=true, paramType="path", dataType="string")})
    public Resource doGetMacro(@PathVariable String applicationId, @PathVariable String macroId) throws Exception {
        try {
            RepositoryVO macro = (RepositoryVO)this.repositoryDesignTimeService.findById(macroId);
            return this.success("ok", macro);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/macros"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u51fd\u6570\u5e93", notes="\u65b0\u5efa\u51fd\u6570\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateMacros(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            RepositoryVO rv = (RepositoryVO)this.json2obj(json, RepositoryVO.class);
            rv.setApplicationid(applicationId);
            rv.setParentId(applicationId);
            if (StringUtil.isBlank((String)rv.getId())) {
                rv.setId(Sequence.getDesignTimeSequence());
            }
            this.doSaveValidate(rv);
            this.repositoryDesignTimeService.doCreate(rv);
            JSONObject formJson = new JSONObject();
            formJson.put((Object)"id", (Object)rv.getId());
            return this.success("ok", formJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/macros/{macroId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u51fd\u6570\u5e93", notes="\u66f4\u65b0\u51fd\u6570\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="macroId", value="\u51fd\u6570\u5e93id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateMacros(@PathVariable String applicationId, @PathVariable String macroId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            RepositoryVO rv = (RepositoryVO)this.json2obj(json, RepositoryVO.class);
            RepositoryVO oldMacro = (RepositoryVO)this.repositoryDesignTimeService.findById(macroId);
            RepositoryVO macro = (RepositoryVO)BeanUtils.cloneBean((Object)oldMacro);
            macro.setApplicationid(applicationId);
            macro.setContent(rv.getContent());
            macro.setName(rv.getName());
            macro.setDescription(rv.getDescription());
            this.doSaveValidate(macro);
            this.repositoryDesignTimeService.doUpdate(macro);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/{applicationId}/macros"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u51fd\u6570\u5e93", notes="\u5220\u9664\u51fd\u6570\u5e93\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteMacros(@RequestBody String[] ids) throws Exception {
        try {
            this.repositoryDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(RepositoryVO repositoryVO) throws Exception {
        RepositoryVO po = this.repositoryDesignTimeService.getRepositoryByName(repositoryVO.getName(), repositoryVO.getApplicationid());
        if (po != null && StringUtil.isBlank((String)repositoryVO.getId())) {
            throw new OBPMValidateException(" \u5e93\u540d\u79f0\u91cd\u590d ,\u8bf7\u91cd\u65b0\u547d\u540d\u518d\u4fdd\u5b58\uff01 ");
        }
        if (po != null && !StringUtil.isBlank((String)repositoryVO.getId()) && !repositoryVO.getId().equals(po.getId())) {
            throw new OBPMValidateException(" \u5e93\u540d\u79f0\u91cd\u590d ,\u8bf7\u91cd\u65b0\u547d\u540d\u518d\u4fdd\u5b58\uff01 ");
        }
    }
}

