/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.dts.excelimport.config.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"excel\u914d\u7f6e\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ExcelConfigsController
extends AbstractDesignTimeController {
    private IMPMappingConfigDesignTimeService impMappingConfigDesignTimeService = DesignTimeServiceManager.impMappingConfigDesignTimeService();

    @GetMapping(path={"/{applicationId}/excelconfigs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6excel\u914d\u7f6e\u5217\u8868", notes="\u83b7\u53d6excel\u914d\u7f6e\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u884c\u6570", required=false, paramType="query", dataType="string")})
    public Resource doGetExcelList(@PathVariable String applicationId, @RequestParam(required=false) String name, String pageNo, String linesPerPage) throws Exception {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage impMappingConfigVOs = this.impMappingConfigDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", impMappingConfigVOs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/excelconfigs/{excelConfigId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6excel\u914d\u7f6e\u8be6\u60c5", notes="\u83b7\u53d6excel\u914d\u7f6e\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="excelConfigId", value="excel\u914d\u7f6eid", required=true, paramType="path", dataType="string")})
    public Resource doGetExcelDetailed(@PathVariable String applicationId, @PathVariable String excelConfigId) throws Exception {
        try {
            IMPMappingConfigVO impMappingConfigVO = (IMPMappingConfigVO)this.impMappingConfigDesignTimeService.findById(excelConfigId);
            return this.success("ok", impMappingConfigVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/excelconfigs"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efaexcel\u914d\u7f6e", notes="\u65b0\u5efaexcel\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateForm(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            IMPMappingConfigVO impMappingConfigVO = (IMPMappingConfigVO)this.json2obj(json, IMPMappingConfigVO.class);
            impMappingConfigVO.setApplicationid(applicationId);
            impMappingConfigVO.setParentId(applicationId);
            String impMappingConfigId = Sequence.getDesignTimeSequence();
            impMappingConfigVO.setId(impMappingConfigId);
            this.doSaveValidate(impMappingConfigVO);
            this.impMappingConfigDesignTimeService.save((Object)impMappingConfigVO);
            JSONObject impMappingConfigIdJson = new JSONObject();
            impMappingConfigIdJson.put((Object)"id", (Object)impMappingConfigId);
            return this.success("ok", impMappingConfigIdJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/excelconfigs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0excel\u914d\u7f6e", notes="\u66f4\u65b0excel\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="impId", value="excel\u914d\u7f6eid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateForm(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            IMPMappingConfigVO impMappingConfigVO = (IMPMappingConfigVO)this.json2obj(json, IMPMappingConfigVO.class);
            impMappingConfigVO.setApplicationid(applicationId);
            impMappingConfigVO.setParentId(applicationId);
            this.doSaveValidate(impMappingConfigVO);
            this.impMappingConfigDesignTimeService.doUpdate(impMappingConfigVO);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/excelconfigs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664excel\u914d\u7f6e", notes="\u5220\u9664excel\u914d\u7f6e\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteForm(@RequestBody String[] ids) throws Exception {
        try {
            this.impMappingConfigDesignTimeService.delete(ids);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(IMPMappingConfigVO impMappingConfigVO) throws Exception {
        List list = this.impMappingConfigDesignTimeService.list(impMappingConfigVO.getParentId(), impMappingConfigVO.getName());
        if (StringUtils.isBlank((String)impMappingConfigVO.getId())) {
            for (IMPMappingConfigVO r : list) {
                if (!r.getName().equals(impMappingConfigVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (IMPMappingConfigVO r : list) {
                if (r.getId().equals(impMappingConfigVO.getId()) || !r.getName().equals(impMappingConfigVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        for (IMPMappingConfigVO r : list) {
            if (!r.getName().equals(impMappingConfigVO.getName()) || r.getId().equals(impMappingConfigVO.getId())) continue;
            throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }
}

