/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.compile.controller;

import cn.myapps.common.Environment;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.helper.service.HelpHelper;
import cn.myapps.runtime.macro.runner.CompileHelper;
import cn.myapps.util.http.CookieUtil;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.xml.sax.SAXException;

@Component
@RequestMapping(value={"/api/designtime"})
@Scope(value="prototype")
public class CompileController
extends AbstractDesignTimeController {
    @PostMapping(path={"/applications/iscript/compile"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u811a\u672c\u9884\u7f16\u8bd1", notes="\u811a\u672c\u9884\u7f16\u8bd1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u811a\u672c\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource compile(@RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            String iscriptString = (String)json.get("iscriptString");
            String result = CompileHelper.compile((String)iscriptString, (HttpServletRequest)this.request);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/applications/iscript/getIscriptHelp"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u811a\u672c\u5e2e\u52a9\u63a5\u53e3", notes="\u811a\u672c\u5e2e\u52a9\u63a5\u53e3")
    public Resource getIscriptHelp(String staticPath) throws Exception {
        String iscriptHtml = "";
        HelpHelper hhelper = new HelpHelper();
        Environment.getInstance().setContextPath(this.request.getContextPath());
        String language = CookieUtil.getMultiLanguage((HttpServletRequest)this.request);
        try {
            iscriptHtml = hhelper.getIscriptHelp(language, staticPath);
            return this.success("ok", iscriptHtml);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

